/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sonarsource.sonarlint.core.clientapi.SonarLintBackend;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.analysis.AnalysisService;
import org.sonarsource.sonarlint.core.clientapi.backend.binding.BindingService;
import org.sonarsource.sonarlint.core.clientapi.backend.branch.SonarProjectBranchService;
import org.sonarsource.sonarlint.core.clientapi.backend.config.ConfigurationService;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.ConnectionService;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.HotspotService;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.IssueService;
import org.sonarsource.sonarlint.core.clientapi.backend.newcode.NewCodeService;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RulesService;
import org.sonarsource.sonarlint.core.clientapi.backend.telemetry.TelemetryService;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.IssueTrackingService;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.SecurityHotspotMatchingService;
import org.sonarsource.sonarlint.core.clientapi.backend.usertoken.UserTokenService;
import org.sonarsource.sonarlint.core.embedded.server.EmbeddedServer;
import org.sonarsource.sonarlint.core.http.ConnectionAwareHttpClientProvider;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.spring.SonarLintSpringAppConfig;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.sonarsource.sonarlint.shaded.org.springframework.context.ConfigurableApplicationContext;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SonarLintBackendImpl
implements SonarLintBackend {
    private final SonarLintClient client;
    private final AtomicBoolean initializeCalled = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();

    public SonarLintBackendImpl(SonarLintClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<Void> initialize(InitializeParams params) {
        return CompletableFuture.runAsync(() -> {
            if (!this.initializeCalled.compareAndSet(false, true) || this.initialized.get()) {
                throw new UnsupportedOperationException("Already initialized");
            }
            this.applicationContext.register(SonarLintSpringAppConfig.class);
            this.applicationContext.registerBean("sonarlintClient", SonarLintClient.class, () -> this.client, new BeanDefinitionCustomizer[0]);
            this.applicationContext.registerBean("initializeParams", InitializeParams.class, () -> params, new BeanDefinitionCustomizer[0]);
            this.applicationContext.refresh();
            this.initialized.set(true);
        });
    }

    protected ConfigurableApplicationContext getInitializedApplicationContext() {
        if (!this.initialized.get()) {
            throw new IllegalStateException("Backend is not initialized");
        }
        return this.applicationContext;
    }

    @Override
    public ConnectionService getConnectionService() {
        return this.getInitializedApplicationContext().getBean(ConnectionService.class);
    }

    @Override
    public ConfigurationService getConfigurationService() {
        return this.getInitializedApplicationContext().getBean(ConfigurationService.class);
    }

    @Override
    public HotspotService getHotspotService() {
        return this.getInitializedApplicationContext().getBean(HotspotService.class);
    }

    @Override
    public TelemetryService getTelemetryService() {
        return this.getInitializedApplicationContext().getBean(TelemetryService.class);
    }

    @Override
    public AnalysisService getAnalysisService() {
        return this.getInitializedApplicationContext().getBean(AnalysisService.class);
    }

    @Override
    public RulesService getRulesService() {
        return this.getInitializedApplicationContext().getBean(RulesService.class);
    }

    @Override
    public BindingService getBindingService() {
        return this.getInitializedApplicationContext().getBean(BindingService.class);
    }

    @Override
    public SonarProjectBranchService getSonarProjectBranchService() {
        return this.getInitializedApplicationContext().getBean(SonarProjectBranchService.class);
    }

    @Override
    public IssueService getIssueService() {
        return this.getInitializedApplicationContext().getBean(IssueService.class);
    }

    @Override
    public IssueTrackingService getIssueTrackingService() {
        return this.getInitializedApplicationContext().getBean(IssueTrackingService.class);
    }

    @Override
    public SecurityHotspotMatchingService getSecurityHotspotMatchingService() {
        return this.getInitializedApplicationContext().getBean(SecurityHotspotMatchingService.class);
    }

    @Override
    public NewCodeService getNewCodeService() {
        return this.getInitializedApplicationContext().getBean(NewCodeService.class);
    }

    @Override
    public UserTokenService getUserTokenService() {
        return this.getInitializedApplicationContext().getBean(UserTokenService.class);
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        return CompletableFuture.runAsync(() -> {
            this.initialized.set(false);
            this.applicationContext.close();
        });
    }

    public int getEmbeddedServerPort() {
        return this.getInitializedApplicationContext().getBean(EmbeddedServer.class).getPort();
    }

    @Override
    public HttpClient getHttpClientNoAuth() {
        return this.getInitializedApplicationContext().getBean(ConnectionAwareHttpClientProvider.class).getHttpClient();
    }

    @Override
    public HttpClient getHttpClient(String connectionId) {
        return this.getInitializedApplicationContext().getBean(ConnectionAwareHttpClientProvider.class).getHttpClient(connectionId);
    }
}

