/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.api;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.analysis.api.ActiveRule;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.commons.Language;

@Immutable
public class AnalysisConfiguration {
    private final Iterable<ClientInputFile> inputFiles;
    private final Map<String, String> extraProperties;
    private final Path baseDir;
    private final Collection<ActiveRule> activeRules;
    private final String toString;

    private AnalysisConfiguration(Builder builder) {
        this.baseDir = builder.baseDir;
        this.inputFiles = builder.inputFiles;
        this.extraProperties = builder.extraProperties;
        this.activeRules = builder.activeRules;
        this.toString = this.generateToString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> extraProperties() {
        return this.extraProperties;
    }

    public Path baseDir() {
        return this.baseDir;
    }

    public Iterable<ClientInputFile> inputFiles() {
        return this.inputFiles;
    }

    public Collection<ActiveRule> activeRules() {
        return this.activeRules;
    }

    public String toString() {
        return this.toString;
    }

    private String generateToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        this.generateToStringCommon(sb);
        sb.append("  activeRules: ").append(this.activeRules).append("\n");
        this.generateToStringInputFiles(sb);
        sb.append("]\n");
        return sb.toString();
    }

    protected void generateToStringCommon(StringBuilder sb) {
        sb.append("  baseDir: ").append(this.baseDir()).append("\n");
        sb.append("  extraProperties: ").append(this.extraProperties()).append("\n");
    }

    protected void generateToStringInputFiles(StringBuilder sb) {
        sb.append("  inputFiles: [\n");
        for (ClientInputFile inputFile : this.inputFiles()) {
            Language language;
            sb.append("    ").append(inputFile.uri());
            sb.append(" (").append(AnalysisConfiguration.getCharsetLabel(inputFile)).append(")");
            if (inputFile.isTest()) {
                sb.append(" [test]");
            }
            if ((language = inputFile.language()) != null) {
                sb.append(" [" + language.getLanguageKey() + "]");
            }
            sb.append("\n");
        }
        sb.append("  ]\n");
    }

    private static String getCharsetLabel(ClientInputFile inputFile) {
        Charset charset = inputFile.getCharset();
        return charset != null ? charset.displayName() : "default";
    }

    public static final class Builder {
        private final List<ClientInputFile> inputFiles = new ArrayList<ClientInputFile>();
        private final Map<String, String> extraProperties = new HashMap<String, String>();
        private Path baseDir;
        private final Collection<ActiveRule> activeRules = new ArrayList<ActiveRule>();

        private Builder() {
        }

        public Builder addInputFiles(ClientInputFile ... inputFiles) {
            Collections.addAll(this.inputFiles, inputFiles);
            return this;
        }

        public Builder addInputFiles(Collection<? extends ClientInputFile> inputFiles) {
            this.inputFiles.addAll(inputFiles);
            return this;
        }

        public Builder addInputFile(ClientInputFile inputFile) {
            this.inputFiles.add(inputFile);
            return this;
        }

        public Builder putAllExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties.putAll(extraProperties);
            return this;
        }

        public Builder putExtraProperty(String key, String value) {
            this.extraProperties.put(key, value);
            return this;
        }

        public Builder setBaseDir(Path baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public Builder addActiveRules(ActiveRule ... activeRules) {
            Collections.addAll(this.activeRules, activeRules);
            return this;
        }

        public Builder addActiveRules(Collection<? extends ActiveRule> activeRules) {
            this.activeRules.addAll(activeRules);
            return this;
        }

        public Builder addActiveRule(ActiveRule activeRules) {
            this.activeRules.add(activeRules);
            return this;
        }

        public AnalysisConfiguration build() {
            return new AnalysisConfiguration(this);
        }
    }
}

