/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FilenameUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class SonarLintPathPattern {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    final WildcardPattern pattern;

    public SonarLintPathPattern(String pattern) {
        if (((String)pattern).startsWith("file:")) {
            LOG.warn("Unsupported path pattern: " + (String)pattern);
            pattern = ((String)pattern).replaceAll("^file:/*", "");
        }
        if (!((String)pattern).startsWith("**/")) {
            pattern = "**/" + (String)pattern;
        }
        this.pattern = WildcardPattern.create((String)pattern);
    }

    public static SonarLintPathPattern[] create(String[] s) {
        SonarLintPathPattern[] result = new SonarLintPathPattern[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = new SonarLintPathPattern(s[i]);
        }
        return result;
    }

    public boolean match(InputFile inputFile) {
        return this.match(inputFile.relativePath(), true);
    }

    public boolean match(String filePath) {
        return this.match(filePath, true);
    }

    public boolean match(InputFile inputFile, boolean caseSensitiveFileExtension) {
        return this.match(inputFile.relativePath(), caseSensitiveFileExtension);
    }

    public boolean match(String filePath, boolean caseSensitiveFileExtension) {
        String extension;
        Object path = PathUtils.sanitize(filePath);
        if (!caseSensitiveFileExtension && StringUtils.isNotBlank(extension = SonarLintPathPattern.sanitizeExtension(FilenameUtils.getExtension((String)path)))) {
            path = StringUtils.removeEndIgnoreCase((String)path, extension);
            path = (String)path + extension;
        }
        return path != null && this.pattern.match((String)path);
    }

    public String toString() {
        return this.pattern.toString();
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase(StringUtils.removeStart(suffix, "."));
    }
}

