/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.utils.PathUtils;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.DefaultTextPointer;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.DefaultTextRange;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.FileMetadata;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.shaded.org.apache.commons.codec.digest.DigestUtils;

public class SonarLintInputFile
implements InputFile {
    private final ClientInputFile clientInputFile;
    private final String relativePath;
    private Language language;
    private InputFile.Type type;
    private FileMetadata.Metadata metadata;
    private final Function<SonarLintInputFile, FileMetadata.Metadata> metadataGenerator;
    private boolean ignoreAllIssues;
    private final Set<Integer> noSonarLines = new HashSet<Integer>();
    private Collection<int[]> ignoreIssuesOnlineRanges;

    public SonarLintInputFile(ClientInputFile clientInputFile, Function<SonarLintInputFile, FileMetadata.Metadata> metadataGenerator) {
        this.clientInputFile = clientInputFile;
        this.metadataGenerator = metadataGenerator;
        this.relativePath = PathUtils.sanitize(clientInputFile.relativePath());
    }

    public void checkMetadata() {
        if (this.metadata == null) {
            this.metadata = this.metadataGenerator.apply(this);
        }
    }

    public ClientInputFile getClientInputFile() {
        return this.clientInputFile;
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    public SonarLintInputFile setLanguage(@Nullable Language language) {
        this.language = language;
        return this;
    }

    public SonarLintInputFile setType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language != null ? this.language.getLanguageKey() : null;
    }

    @CheckForNull
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    @Deprecated
    public String absolutePath() {
        return PathUtils.sanitize(this.clientInputFile.getPath());
    }

    @Override
    @Deprecated
    public File file() {
        return this.path().toFile();
    }

    @Override
    @Deprecated
    public Path path() {
        return Paths.get(this.clientInputFile.getPath(), new String[0]);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return this.clientInputFile.inputStream();
    }

    @Override
    public String contents() throws IOException {
        return this.clientInputFile.contents();
    }

    @Override
    public InputFile.Status status() {
        return InputFile.Status.ADDED;
    }

    @Override
    public String key() {
        return this.uri().toString();
    }

    @Override
    public URI uri() {
        return this.clientInputFile.uri();
    }

    @Override
    public Charset charset() {
        Charset charset = this.clientInputFile.getCharset();
        return charset != null ? charset : Charset.defaultCharset();
    }

    @Override
    public String md5Hash() {
        try {
            return DigestUtils.md5Hex(this.contents());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to compute md5Hash for " + this.uri(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SonarLintInputFile)) {
            return false;
        }
        SonarLintInputFile that = (SonarLintInputFile)o;
        return this.uri().equals(that.uri());
    }

    public int hashCode() {
        return this.uri().hashCode();
    }

    @Override
    public String toString() {
        return "[uri=" + this.uri() + "]";
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public String filename() {
        return Paths.get(this.relativePath, new String[0]).getFileName().toString();
    }

    @Override
    public int lines() {
        this.checkMetadata();
        return this.metadata.lines();
    }

    @Override
    public boolean isEmpty() {
        this.checkMetadata();
        return this.metadata.lastValidOffset() == 0;
    }

    @Override
    public TextPointer newPointer(int line, int lineOffset) {
        this.checkMetadata();
        return new DefaultTextPointer(line, lineOffset);
    }

    @Override
    public TextRange newRange(TextPointer start, TextPointer end) {
        this.checkMetadata();
        return SonarLintInputFile.newRangeValidPointers(start, end);
    }

    @Override
    public TextRange newRange(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        this.checkMetadata();
        TextPointer start = this.newPointer(startLine, startLineOffset);
        TextPointer end = this.newPointer(endLine, endLineOffset);
        return SonarLintInputFile.newRangeValidPointers(start, end);
    }

    @Override
    public TextRange selectLine(int line) {
        this.checkMetadata();
        TextPointer startPointer = this.newPointer(line, 0);
        TextPointer endPointer = this.newPointer(line, this.lineLength(line));
        return SonarLintInputFile.newRangeValidPointers(startPointer, endPointer);
    }

    private static TextRange newRangeValidPointers(TextPointer start, TextPointer end) {
        return new DefaultTextRange(start, end);
    }

    private int lineLength(int line) {
        return this.lastValidGlobalOffsetForLine(line) - this.metadata.originalLineOffsets()[line - 1];
    }

    private int lastValidGlobalOffsetForLine(int line) {
        return line < this.metadata.lines() ? this.metadata.originalLineOffsets()[line] - 1 : this.metadata.lastValidOffset();
    }

    public void noSonarAt(Set<Integer> noSonarLines) {
        this.noSonarLines.addAll(noSonarLines);
    }

    public boolean hasNoSonarAt(int line) {
        return this.noSonarLines.contains(line);
    }

    public boolean isIgnoreAllIssues() {
        this.checkMetadata();
        return this.ignoreAllIssues;
    }

    public void setIgnoreAllIssues(boolean ignoreAllIssues) {
        this.ignoreAllIssues = ignoreAllIssues;
    }

    public void addIgnoreIssuesOnLineRanges(Collection<int[]> lineRanges) {
        if (this.ignoreIssuesOnlineRanges == null) {
            this.ignoreIssuesOnlineRanges = new ArrayList<int[]>();
        }
        this.ignoreIssuesOnlineRanges.addAll(lineRanges);
    }

    public boolean isIgnoreAllIssuesOnLine(@Nullable Integer line) {
        this.checkMetadata();
        if (line == null || this.ignoreIssuesOnlineRanges == null) {
            return false;
        }
        return this.ignoreIssuesOnlineRanges.stream().anyMatch(r -> r[0] <= line && line <= r[1]);
    }
}

