/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.global;

import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.AnnotationUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.analysis.container.ContainerLifespan;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.plugin.commons.ExtensionInstaller;
import org.sonarsource.sonarlint.core.plugin.commons.ExtensionUtils;
import org.sonarsource.sonarlint.core.plugin.commons.LoadedPlugins;
import org.sonarsource.sonarlint.core.plugin.commons.container.ExtensionContainer;
import org.sonarsource.sonarlint.plugin.api.SonarLintRuntime;

public class AnalysisExtensionInstaller
extends ExtensionInstaller {
    private final LoadedPlugins loadedPlugins;

    public AnalysisExtensionInstaller(SonarLintRuntime sonarRuntime, LoadedPlugins loadedPlugins, Configuration bootConfiguration) {
        super(sonarRuntime, bootConfiguration);
        this.loadedPlugins = loadedPlugins;
    }

    public AnalysisExtensionInstaller install(ExtensionContainer container, ContainerLifespan lifespan) {
        super.install(container, this.loadedPlugins.getPluginInstancesByKeys(), (pluginKey, extension) -> lifespan.equals((Object)AnalysisExtensionInstaller.getSonarLintSideLifespan(extension)) && this.onlySonarSourceSensor((String)pluginKey, extension));
        return this;
    }

    private static ContainerLifespan getSonarLintSideLifespan(Object extension) {
        SonarLintSide annotation = AnnotationUtils.getAnnotation(extension, SonarLintSide.class);
        if (annotation != null) {
            String lifespan = annotation.lifespan();
            if ("MULTIPLE_ANALYSES".equals(lifespan) || "INSTANCE".equals(lifespan)) {
                return ContainerLifespan.INSTANCE;
            }
            if ("MODULE".equals(lifespan)) {
                return ContainerLifespan.MODULE;
            }
            if ("SINGLE_ANALYSIS".equals(lifespan)) {
                return ContainerLifespan.ANALYSIS;
            }
        }
        return null;
    }

    private boolean onlySonarSourceSensor(String pluginKey, Object extension) {
        return Language.containsPlugin(pluginKey) || this.loadedPlugins.getAdditionalAllowedPlugins().contains(pluginKey) || AnalysisExtensionInstaller.isNotSensor(extension);
    }

    private static boolean isNotSensor(Object extension) {
        return !ExtensionUtils.isType(extension, Sensor.class);
    }
}

