/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.module;

import java.util.List;
import java.util.Optional;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleFileEvent;
import org.sonarsource.sonarlint.core.analysis.container.module.DefaultModuleFileEvent;
import org.sonarsource.sonarlint.core.analysis.container.module.ModuleInputFileBuilder;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileEvent;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileListener;

public class ModuleFileEventNotifier {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final List<ModuleFileListener> listeners;
    private final ModuleInputFileBuilder inputFileBuilder;

    public ModuleFileEventNotifier(Optional<List<ModuleFileListener>> listeners, ModuleInputFileBuilder inputFileBuilder) {
        this.listeners = listeners.orElse(List.of());
        this.inputFileBuilder = inputFileBuilder;
    }

    public void fireModuleFileEvent(ClientModuleFileEvent event) {
        DefaultModuleFileEvent apiEvent = DefaultModuleFileEvent.of(this.inputFileBuilder.create(event.target()), event.type());
        this.listeners.forEach(l -> ModuleFileEventNotifier.tryFireModuleFileEvent(l, apiEvent));
    }

    private static void tryFireModuleFileEvent(ModuleFileListener listener, ModuleFileEvent event) {
        try {
            listener.process(event);
        }
        catch (Exception e) {
            LOG.error("Error processing file event", e);
        }
    }
}

