/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.sonarapi;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.fix.QuickFix;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.PathUtils;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputProject;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.SensorQuickFix;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultFlow;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultSonarLintIssueLocation;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultStorable;
import org.sonarsource.sonarlint.plugin.api.issue.NewQuickFix;
import org.sonarsource.sonarlint.plugin.api.issue.NewSonarLintIssue;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class DefaultSonarLintIssue
extends DefaultStorable
implements Issue,
NewIssue,
NewSonarLintIssue {
    private final SonarLintInputProject project;
    private final Path baseDir;
    protected DefaultSonarLintIssueLocation primaryLocation;
    protected List<Issue.Flow> flows = new ArrayList<Issue.Flow>();
    private RuleKey ruleKey;
    private Severity overriddenSeverity;
    private final List<QuickFix> quickFixes;
    private Optional<String> ruleDescriptionContextKey = Optional.empty();
    private final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> overriddenImpacts;

    public DefaultSonarLintIssue(SonarLintInputProject project, Path baseDir, @Nullable SensorStorage storage) {
        super(storage);
        this.project = project;
        this.baseDir = baseDir;
        this.quickFixes = new ArrayList<QuickFix>();
        this.overriddenImpacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);
    }

    @Override
    public NewIssueLocation newLocation() {
        return new DefaultSonarLintIssueLocation();
    }

    @Override
    public NewIssue setRuleDescriptionContextKey(@Nullable String ruleDescriptionContextKey) {
        this.ruleDescriptionContextKey = Optional.ofNullable(ruleDescriptionContextKey);
        return this;
    }

    @Override
    public NewIssue setCodeVariants(@Nullable Iterable<String> iterable) {
        return this;
    }

    @Override
    public DefaultSonarLintIssue forRule(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    public DefaultSonarLintIssue gap(@Nullable Double gap) {
        return this;
    }

    @Override
    public DefaultSonarLintIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    @Override
    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    @Override
    public DefaultSonarLintIssue overrideImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
        this.overriddenImpacts.put(softwareQuality, severity);
        return this;
    }

    @Override
    public Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> overridenImpacts() {
        return this.overriddenImpacts;
    }

    @Override
    public Double gap() {
        throw new UnsupportedOperationException("No gap in SonarLint");
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public List<Issue.Flow> flows() {
        return this.flows;
    }

    @Override
    public DefaultSonarLintIssue at(NewIssueLocation primaryLocation) {
        this.primaryLocation = this.rewriteLocation((DefaultSonarLintIssueLocation)primaryLocation);
        return this;
    }

    @Override
    public NewIssue addLocation(NewIssueLocation secondaryLocation) {
        return this.addFlow(List.of(secondaryLocation));
    }

    @Override
    public NewIssue addFlow(Iterable<NewIssueLocation> locations) {
        return this.addFlow(locations, NewIssue.FlowType.UNDEFINED, null);
    }

    @Override
    public NewIssue addFlow(Iterable<NewIssueLocation> flowLocations, NewIssue.FlowType flowType, @Nullable String flowDescription) {
        ArrayList<IssueLocation> flowAsList = new ArrayList<IssueLocation>();
        for (NewIssueLocation issueLocation : flowLocations) {
            flowAsList.add(this.rewriteLocation((DefaultSonarLintIssueLocation)issueLocation));
        }
        this.flows.add(new DefaultFlow(flowAsList, flowDescription, flowType));
        return this;
    }

    private DefaultSonarLintIssueLocation rewriteLocation(DefaultSonarLintIssueLocation location) {
        InputComponent component = location.inputComponent();
        Optional<Object> dirOrModulePath = Optional.empty();
        if (component instanceof InputDir) {
            InputDir dirComponent = (InputDir)component;
            dirOrModulePath = Optional.of(this.baseDir.relativize(dirComponent.path()));
        }
        if (dirOrModulePath.isPresent()) {
            String path = PathUtils.sanitize(((Path)dirOrModulePath.get()).toString());
            DefaultSonarLintIssueLocation fixedLocation = new DefaultSonarLintIssueLocation();
            fixedLocation.on(this.project);
            StringBuilder fullMessage = new StringBuilder();
            if (!StringUtils.isEmpty(path)) {
                fullMessage.append("[").append(path).append("] ");
            }
            fullMessage.append(location.message());
            fixedLocation.message(fullMessage.toString());
            return fixedLocation;
        }
        return location;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "ruleKey is mandatory on issue");
        this.storage.store(this);
    }

    @Override
    public SensorQuickFix newQuickFix() {
        return new SensorQuickFix();
    }

    @Override
    public DefaultSonarLintIssue addQuickFix(NewQuickFix newQuickFix) {
        this.quickFixes.add((QuickFix)((Object)newQuickFix));
        return this;
    }

    @Override
    public DefaultSonarLintIssue addQuickFix(org.sonar.api.batch.sensor.issue.fix.NewQuickFix newQuickFix) {
        this.quickFixes.add((QuickFix)((Object)newQuickFix));
        return this;
    }

    @Override
    public List<QuickFix> quickFixes() {
        return Collections.unmodifiableList(this.quickFixes);
    }

    @Override
    @CheckForNull
    public List<String> codeVariants() {
        return Collections.emptyList();
    }

    @Override
    public NewIssue setQuickFixAvailable(boolean qfAvailable) {
        return this;
    }

    @Override
    public boolean isQuickFixAvailable() {
        return !this.quickFixes.isEmpty();
    }

    @Override
    public Optional<String> ruleDescriptionContextKey() {
        return this.ruleDescriptionContextKey;
    }
}

