/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;

public enum HotspotReviewStatus {
    TO_REVIEW(Set.of(ConnectionKind.SONARQUBE, ConnectionKind.SONARCLOUD)),
    SAFE(Set.of(ConnectionKind.SONARQUBE, ConnectionKind.SONARCLOUD)),
    FIXED(Set.of(ConnectionKind.SONARQUBE, ConnectionKind.SONARCLOUD)),
    ACKNOWLEDGED(Set.of(ConnectionKind.SONARQUBE));

    private final Set<ConnectionKind> allowedConnectionKinds;

    private HotspotReviewStatus(Set<ConnectionKind> allowedConnectionKinds) {
        this.allowedConnectionKinds = allowedConnectionKinds;
    }

    public boolean isReviewed() {
        return !this.equals((Object)TO_REVIEW);
    }

    public boolean isResolved() {
        return this.equals((Object)SAFE) || this.equals((Object)FIXED);
    }

    public static HotspotReviewStatus fromStatusAndResolution(String status, @Nullable String resolution) {
        if ("REVIEWED".equals(status) && resolution != null) {
            switch (resolution) {
                case "SAFE": {
                    return SAFE;
                }
                case "FIXED": {
                    return FIXED;
                }
                case "ACKNOWLEDGED": {
                    return ACKNOWLEDGED;
                }
            }
            return TO_REVIEW;
        }
        return TO_REVIEW;
    }

    private boolean isAllowedOn(ConnectionKind kind) {
        return this.allowedConnectionKinds.contains((Object)kind);
    }

    public static List<HotspotReviewStatus> allowedStatusesOn(ConnectionKind kind) {
        return Arrays.stream(HotspotReviewStatus.values()).filter(status -> status.isAllowedOn(kind)).collect(Collectors.toList());
    }
}

