/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons;

import java.time.Instant;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.IssueStatus;
import org.sonarsource.sonarlint.core.commons.LineWithHash;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssueResolution;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;

public class LocalOnlyIssue {
    private final UUID id;
    private final String serverRelativePath;
    private final TextRangeWithHash textRangeWithHash;
    private final LineWithHash lineWithHash;
    private final String ruleKey;
    private final String message;
    private LocalOnlyIssueResolution resolution;

    public LocalOnlyIssue(UUID id, String serverRelativePath, @Nullable TextRangeWithHash textRangeWithHash, @Nullable LineWithHash lineWithHash, String ruleKey, String message, @Nullable LocalOnlyIssueResolution resolution) {
        this.id = id;
        this.serverRelativePath = serverRelativePath;
        this.textRangeWithHash = textRangeWithHash;
        this.lineWithHash = lineWithHash;
        this.ruleKey = ruleKey;
        this.message = message;
        this.resolution = resolution;
    }

    public UUID getId() {
        return this.id;
    }

    public String getServerRelativePath() {
        return this.serverRelativePath;
    }

    @CheckForNull
    public TextRangeWithHash getTextRangeWithHash() {
        return this.textRangeWithHash;
    }

    @CheckForNull
    public LineWithHash getLineWithHash() {
        return this.lineWithHash;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public String getMessage() {
        return this.message;
    }

    @CheckForNull
    public LocalOnlyIssueResolution getResolution() {
        return this.resolution;
    }

    public void resolve(IssueStatus newStatus) {
        this.resolution = new LocalOnlyIssueResolution(newStatus, Instant.now(), null);
    }
}

