/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.issuetracking;

import java.util.ArrayList;
import java.util.Collection;
import org.sonarsource.sonarlint.core.issuetracking.CombinedTrackable;
import org.sonarsource.sonarlint.core.issuetracking.DisconnectedTrackable;
import org.sonarsource.sonarlint.core.issuetracking.LeakedTrackable;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;
import org.sonarsource.sonarlint.core.issuetracking.Tracker;
import org.sonarsource.sonarlint.core.issuetracking.Tracking;

public class IssueTracker {
    public Collection<Trackable> apply(Collection<Trackable> baseIssues, Collection<Trackable> nextIssues, boolean inheritSeverity) {
        ArrayList<Trackable> trackedIssues = new ArrayList<Trackable>();
        Tracking tracking = new Tracker().track(() -> nextIssues, () -> baseIssues);
        tracking.getMatchedRaws().entrySet().stream().map(e -> new CombinedTrackable((Trackable)e.getValue(), (Trackable)e.getKey(), inheritSeverity)).forEach(trackedIssues::add);
        for (Trackable next : tracking.getUnmatchedRaws()) {
            if (next.getServerIssueKey() != null) {
                next = new DisconnectedTrackable(next);
            } else if (next.getCreationDate() == null) {
                next = new LeakedTrackable(next);
            }
            trackedIssues.add(next);
        }
        return trackedIssues;
    }
}

