/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.issuetracking;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.issuetracking.IssueTrackerCache;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;
import org.sonarsource.sonarlint.core.issuetracking.TrackableIssueStore;

public class PersistentIssueTrackerCache<T>
implements IssueTrackerCache<T> {
    private static final SonarLintLogger LOGGER = SonarLintLogger.get();
    static final int MAX_ENTRIES = 100;
    private final TrackableIssueStore store;
    private final Map<String, Collection<Trackable<T>>> cache;

    public PersistentIssueTrackerCache(TrackableIssueStore store) {
        this.store = store;
        this.cache = new LimitedSizeLinkedHashMap();
    }

    @Override
    public boolean isFirstAnalysis(String file) {
        return !this.cache.containsKey(file) && !this.store.contains(file);
    }

    @Override
    public synchronized Collection<Trackable<T>> getLiveOrFail(String file) {
        Collection<Trackable<T>> liveTrackables = this.cache.get(file);
        if (liveTrackables != null) {
            return liveTrackables;
        }
        throw new IllegalStateException("No issues in cache for file: " + file);
    }

    @Override
    public synchronized Collection<Trackable<T>> getCurrentTrackables(String file) {
        Collection<Trackable<T>> liveTrackables = this.cache.get(file);
        if (liveTrackables != null) {
            return liveTrackables;
        }
        try {
            Collection storedTrackables = this.store.read(file);
            if (storedTrackables != null) {
                return Collections.unmodifiableCollection(storedTrackables);
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to read issues from store for file %s", file), e);
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized void put(String file, Collection<Trackable<T>> trackables) {
        this.cache.put(file, trackables);
    }

    @Override
    public synchronized void clear() {
        this.store.clear();
        this.cache.clear();
    }

    public synchronized void flushAll() {
        LOGGER.debug("Persisting all issues");
        this.cache.forEach((path, trackables) -> {
            try {
                this.store.save((String)path, trackables);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to flush cache", e);
            }
        });
    }

    @Override
    public synchronized void shutdown() {
        this.flushAll();
    }

    private class LimitedSizeLinkedHashMap
    extends LinkedHashMap<String, Collection<Trackable<T>>> {
        LimitedSizeLinkedHashMap() {
            super(100, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Collection<Trackable<T>>> eldest) {
            if (this.size() <= 100) {
                return false;
            }
            String key = eldest.getKey();
            try {
                LOGGER.debug("Persisting issues for " + key);
                PersistentIssueTrackerCache.this.store.save(key, eldest.getValue());
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error persisting issues for %s", key), e);
            }
            return true;
        }
    }
}

