/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.loading;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import org.sonar.api.Plugin;
import org.sonarsource.sonarlint.core.commons.IOExceptionUtils;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginClassLoaderDef;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginClassloaderFactory;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginInfo;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.SystemUtils;

public class PluginInstancesLoader
implements Closeable {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String[] DEFAULT_SHARED_RESOURCES = new String[]{"org/sonar/plugins", "com/sonar/plugins", "com/sonarsource/plugins"};
    private final PluginClassloaderFactory classloaderFactory;
    private final ClassLoader baseClassLoader;
    private final Collection<ClassLoader> classloadersToClose = new ArrayList<ClassLoader>();
    private final List<JarFile> jarFilesToClose = new ArrayList<JarFile>();
    private final List<Path> filesToDelete = new ArrayList<Path>();

    public PluginInstancesLoader() {
        this(new PluginClassloaderFactory());
    }

    PluginInstancesLoader(PluginClassloaderFactory classloaderFactory) {
        this.classloaderFactory = classloaderFactory;
        this.baseClassLoader = this.getClass().getClassLoader();
    }

    public Map<String, Plugin> instantiatePluginClasses(Collection<PluginInfo> plugins) {
        Collection<PluginClassLoaderDef> defs = this.defineClassloaders(plugins.stream().collect(Collectors.toMap(PluginInfo::getKey, p -> p)));
        Map<PluginClassLoaderDef, ClassLoader> classloaders = this.classloaderFactory.create(this.baseClassLoader, defs);
        this.classloadersToClose.addAll(classloaders.values());
        return this.instantiatePluginClasses(classloaders);
    }

    Collection<PluginClassLoaderDef> defineClassloaders(Map<String, PluginInfo> pluginsByKey) {
        HashMap<String, PluginClassLoaderDef> classloadersByBasePlugin = new HashMap<String, PluginClassLoaderDef>();
        for (PluginInfo info : pluginsByKey.values()) {
            String baseKey = PluginInstancesLoader.basePluginKey(info, pluginsByKey);
            if (baseKey == null) continue;
            PluginClassLoaderDef def = classloadersByBasePlugin.computeIfAbsent(baseKey, PluginClassLoaderDef::new);
            def.addFiles(List.of(info.getJarFile()));
            PluginInstancesLoader.getJarFile(info.getJarFile().toPath()).ifPresent(this.jarFilesToClose::add);
            if (!info.getDependencies().isEmpty()) {
                LOG.warn("Plugin '{}' embeds dependencies. This will be deprecated soon. Plugin should be updated.", (Object)info.getKey());
                Path tmpFolderForDeps = PluginInstancesLoader.createTmpFolderForPluginDeps(info);
                for (String dependency : info.getDependencies()) {
                    Path tmpDepFile = PluginInstancesLoader.extractDependencyInTempFolder(info, dependency, tmpFolderForDeps);
                    def.addFiles(List.of(tmpDepFile.toFile()));
                    this.filesToDelete.add(tmpDepFile);
                    PluginInstancesLoader.getJarFile(tmpDepFile).ifPresent(this.jarFilesToClose::add);
                }
            }
            def.addMainClass(info.getKey(), info.getMainClass());
            for (String defaultSharedResource : DEFAULT_SHARED_RESOURCES) {
                def.getExportMask().addInclusion(String.format("%s/%s/api/", defaultSharedResource, info.getKey()));
            }
        }
        return classloadersByBasePlugin.values();
    }

    private static Optional<JarFile> getJarFile(Path tmpDepFile) {
        try {
            return Optional.of(((JarURLConnection)new URL("jar:" + tmpDepFile.toUri().toURL() + "!/").openConnection()).getJarFile());
        }
        catch (ZipException ignore) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Path createTmpFolderForPluginDeps(PluginInfo info) {
        try {
            String prefix = "sonarlint_" + info.getKey();
            return Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create temporary directory", e);
        }
    }

    private static Path extractDependencyInTempFolder(PluginInfo info, String dependency, Path tempFolder) {
        try {
            Path tmpDepFile = tempFolder.resolve(dependency);
            if (!tmpDepFile.startsWith(tempFolder + File.separator)) {
                throw new IOException("Entry is outside of the target dir: " + dependency);
            }
            Files.createDirectories(tmpDepFile.getParent(), new FileAttribute[0]);
            PluginInstancesLoader.extractFile(info.getJarFile().toPath(), dependency, tmpDepFile);
            return tmpDepFile;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to extract plugin dependency: " + dependency, e);
        }
    }

    private static void extractFile(Path zipFile, String fileName, Path outputFile) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(zipFile, (ClassLoader)null);){
            Path fileToExtract = fileSystem.getPath(fileName, new String[0]);
            Files.copy(fileToExtract, outputFile, new CopyOption[0]);
        }
    }

    Map<String, Plugin> instantiatePluginClasses(Map<PluginClassLoaderDef, ClassLoader> classloaders) {
        HashMap<String, Plugin> instancesByPluginKey = new HashMap<String, Plugin>();
        for (Map.Entry<PluginClassLoaderDef, ClassLoader> entry : classloaders.entrySet()) {
            PluginClassLoaderDef def = entry.getKey();
            ClassLoader classLoader = entry.getValue();
            for (Map.Entry<String, String> mainClassEntry : def.getMainClassesByPluginKey().entrySet()) {
                String pluginKey = mainClassEntry.getKey();
                String mainClass = mainClassEntry.getValue();
                try {
                    instancesByPluginKey.put(pluginKey, (Plugin)classLoader.loadClass(mainClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (UnsupportedClassVersionError e) {
                    LOG.error("The plugin [{}] does not support Java {}", pluginKey, SystemUtils.JAVA_RUNTIME_VERSION, e);
                }
                catch (Throwable e) {
                    LOG.error("Fail to instantiate class [{}] of plugin [{}]", mainClass, pluginKey, e);
                }
            }
        }
        return instancesByPluginKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LinkedList<IOException> exceptions = new LinkedList<IOException>();
        Collection<ClassLoader> collection = this.classloadersToClose;
        synchronized (collection) {
            for (ClassLoader classLoader : this.classloadersToClose) {
                if (!(classLoader instanceof Closeable)) continue;
                IOExceptionUtils.tryAndCollectIOException(((Closeable)((Object)classLoader))::close, exceptions);
            }
            this.classloadersToClose.clear();
        }
        collection = this.jarFilesToClose;
        synchronized (collection) {
            for (JarFile jarFile : this.jarFilesToClose) {
                IOExceptionUtils.tryAndCollectIOException(jarFile::close, exceptions);
            }
            this.jarFilesToClose.clear();
        }
        collection = this.filesToDelete;
        synchronized (collection) {
            for (Path fileToDelete : this.filesToDelete) {
                IOExceptionUtils.tryAndCollectIOException(() -> FileUtils.forceDelete(fileToDelete.toFile()), exceptions);
            }
            this.filesToDelete.clear();
        }
        IOExceptionUtils.throwFirstWithOtherSuppressed(exceptions);
    }

    @CheckForNull
    static String basePluginKey(PluginInfo plugin, Map<String, PluginInfo> allPluginsPerKey) {
        String base = plugin.getKey();
        String parentKey = plugin.getBasePlugin();
        while (StringUtils.isNotEmpty(parentKey)) {
            PluginInfo parentPlugin = allPluginsPerKey.get(parentKey);
            if (parentPlugin == null) {
                LOG.warn("Unable to find base plugin '{}' referenced by plugin '{}'", (Object)parentKey, (Object)base);
                return null;
            }
            base = parentPlugin.getKey();
            parentKey = parentPlugin.getBasePlugin();
        }
        return base;
    }
}

