/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.loading;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.Version;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.PluginsMinVersions;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.plugin.commons.ApiVersions;
import org.sonarsource.sonarlint.core.plugin.commons.DataflowBugDetection;
import org.sonarsource.sonarlint.core.plugin.commons.SkipReason;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginRequirementsCheckResult;
import org.sonarsource.sonarlint.core.plugin.commons.loading.SonarPluginManifest;

public class SonarPluginRequirementsChecker {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String OLD_SONARTS_PLUGIN_KEY = "typescript";
    private final PluginsMinVersions pluginMinVersions;
    private final org.sonarsource.sonarlint.core.commons.Version implementedPluginApiVersion;

    public SonarPluginRequirementsChecker() {
        this(new PluginsMinVersions(), ApiVersions.loadSonarPluginApiVersion());
    }

    SonarPluginRequirementsChecker(PluginsMinVersions pluginMinVersions, Version pluginApiVersion) {
        this.pluginMinVersions = pluginMinVersions;
        this.implementedPluginApiVersion = org.sonarsource.sonarlint.core.commons.Version.create(pluginApiVersion.toString());
    }

    public Map<String, PluginRequirementsCheckResult> checkRequirements(Set<Path> pluginJarLocations, Set<Language> enabledLanguages, org.sonarsource.sonarlint.core.commons.Version jreCurrentVersion, boolean shouldCheckNodeVersion, Optional<org.sonarsource.sonarlint.core.commons.Version> nodeCurrentVersion, boolean enableDataflowBugDetection) {
        HashMap<String, PluginRequirementsCheckResult> resultsByKey = new HashMap<String, PluginRequirementsCheckResult>();
        for (Path jarLocation : pluginJarLocations) {
            PluginInfo plugin;
            try {
                plugin = PluginInfo.create(jarLocation);
            }
            catch (Exception e) {
                LOG.error("Unable to load plugin " + jarLocation, e);
                continue;
            }
            if (resultsByKey.containsKey(plugin.getKey())) {
                throw new IllegalStateException("Duplicate plugin key '" + plugin.getKey() + "' from '" + plugin.getJarFile() + "' and '" + ((PluginRequirementsCheckResult)resultsByKey.get(plugin.getKey())).getPlugin().getJarFile() + "'");
            }
            resultsByKey.put(plugin.getKey(), this.checkIfSkippedAndPopulateReason(plugin, enabledLanguages, jreCurrentVersion, shouldCheckNodeVersion, nodeCurrentVersion));
        }
        for (PluginRequirementsCheckResult result : resultsByKey.values()) {
            if (result.isSkipped()) continue;
            resultsByKey.put(result.getPlugin().getKey(), SonarPluginRequirementsChecker.checkUnsatisfiedPluginDependency(result, resultsByKey, enableDataflowBugDetection));
        }
        return resultsByKey;
    }

    private PluginRequirementsCheckResult checkIfSkippedAndPopulateReason(PluginInfo plugin, Set<Language> enabledLanguages, org.sonarsource.sonarlint.core.commons.Version jreCurrentVersion, boolean shouldCheckNodeVersion, Optional<org.sonarsource.sonarlint.core.commons.Version> nodeCurrentVersion) {
        org.sonarsource.sonarlint.core.commons.Version nodeMinVersion;
        String pluginKey = plugin.getKey();
        Set<Language> languages = Language.getLanguagesByPluginKey(pluginKey);
        if (!languages.isEmpty()) {
            if (enabledLanguages.stream().noneMatch(languages::contains)) {
                if (languages.size() > 1) {
                    LOG.debug("Plugin '{}' is excluded because none of languages '{}' are enabled. Skip loading it.", (Object)plugin.getName(), (Object)languages.stream().map(Language::toString).collect(Collectors.joining(",")));
                } else {
                    LOG.debug("Plugin '{}' is excluded because language '{}' is not enabled. Skip loading it.", (Object)plugin.getName(), (Object)languages.iterator().next());
                }
                return new PluginRequirementsCheckResult(plugin, new SkipReason.LanguagesNotEnabled(languages));
            }
        }
        if (!SonarPluginRequirementsChecker.isCompatibleWith(plugin, this.implementedPluginApiVersion)) {
            LOG.debug("Plugin '{}' requires plugin API {} while SonarLint supports only up to {}. Skip loading it.", plugin.getName(), plugin.getMinimalSqVersion(), this.implementedPluginApiVersion.removeQualifier().toString());
            return new PluginRequirementsCheckResult(plugin, SkipReason.IncompatiblePluginApi.INSTANCE);
        }
        String pluginMinVersion = this.pluginMinVersions.getMinimumVersion(pluginKey);
        if (pluginMinVersion != null && !this.pluginMinVersions.isVersionSupported(pluginKey, plugin.getVersion())) {
            LOG.debug("Plugin '{}' version '{}' is not supported (minimal version is '{}'). Skip loading it.", plugin.getName(), plugin.getVersion(), pluginMinVersion);
            return new PluginRequirementsCheckResult(plugin, new SkipReason.IncompatiblePluginVersion(pluginMinVersion));
        }
        org.sonarsource.sonarlint.core.commons.Version jreMinVersion = plugin.getJreMinVersion();
        if (jreMinVersion != null && !jreCurrentVersion.satisfiesMinRequirement(jreMinVersion)) {
            LOG.debug("Plugin '{}' requires JRE {} while current is {}. Skip loading it.", plugin.getName(), jreMinVersion, jreCurrentVersion);
            return new PluginRequirementsCheckResult(plugin, new SkipReason.UnsatisfiedRuntimeRequirement(SkipReason.UnsatisfiedRuntimeRequirement.RuntimeRequirement.JRE, jreCurrentVersion.toString(), jreMinVersion.toString()));
        }
        if (shouldCheckNodeVersion && (nodeMinVersion = plugin.getNodeJsMinVersion()) != null) {
            if (nodeCurrentVersion.isEmpty()) {
                LOG.debug("Plugin '{}' requires Node.js {}. Skip loading it.", (Object)plugin.getName(), (Object)nodeMinVersion);
                return new PluginRequirementsCheckResult(plugin, new SkipReason.UnsatisfiedRuntimeRequirement(SkipReason.UnsatisfiedRuntimeRequirement.RuntimeRequirement.NODEJS, null, nodeMinVersion.toString()));
            }
            if (!nodeCurrentVersion.get().satisfiesMinRequirement(nodeMinVersion)) {
                LOG.debug("Plugin '{}' requires Node.js {} while current is {}. Skip loading it.", plugin.getName(), nodeMinVersion, nodeCurrentVersion.get());
                return new PluginRequirementsCheckResult(plugin, new SkipReason.UnsatisfiedRuntimeRequirement(SkipReason.UnsatisfiedRuntimeRequirement.RuntimeRequirement.NODEJS, nodeCurrentVersion.get().toString(), nodeMinVersion.toString()));
            }
        }
        return new PluginRequirementsCheckResult(plugin, null);
    }

    static boolean isCompatibleWith(PluginInfo plugin, org.sonarsource.sonarlint.core.commons.Version implementedApiVersion) {
        org.sonarsource.sonarlint.core.commons.Version sonarMinVersion = plugin.getMinimalSqVersion();
        if (sonarMinVersion == null) {
            return true;
        }
        org.sonarsource.sonarlint.core.commons.Version requestedApi = org.sonarsource.sonarlint.core.commons.Version.create(sonarMinVersion.getMajor() + "." + sonarMinVersion.getMinor());
        return implementedApiVersion.satisfiesMinRequirement(requestedApi);
    }

    private static PluginRequirementsCheckResult checkUnsatisfiedPluginDependency(PluginRequirementsCheckResult currentResult, Map<String, PluginRequirementsCheckResult> currentResultsByKey, boolean enableDataflowBugDetection) {
        PluginInfo plugin = currentResult.getPlugin();
        for (SonarPluginManifest.RequiredPlugin required : plugin.getRequiredPlugins()) {
            PluginRequirementsCheckResult depInfo;
            if ("license".equals(required.getKey()) || Language.JS.getPluginKey().equals(plugin.getKey()) && OLD_SONARTS_PLUGIN_KEY.equals(required.getKey()) || (depInfo = currentResultsByKey.get(required.getKey())) != null && !depInfo.isSkipped()) continue;
            return SonarPluginRequirementsChecker.processUnsatisfiedDependency(currentResult.getPlugin(), required.getKey());
        }
        String basePluginKey = plugin.getBasePlugin();
        if (basePluginKey != null && SonarPluginRequirementsChecker.checkForPluginSkipped(currentResultsByKey.get(basePluginKey))) {
            return SonarPluginRequirementsChecker.processUnsatisfiedDependency(currentResult.getPlugin(), basePluginKey);
        }
        if (DataflowBugDetection.PLUGIN_ALLOW_LIST.contains(plugin.getKey())) {
            if (!enableDataflowBugDetection) {
                LOG.debug("Plugin '{}' is not supported. Skip loading it.", (Object)plugin.getName());
                return new PluginRequirementsCheckResult(plugin, SkipReason.UnsupportedPlugin.INSTANCE);
            }
            PluginRequirementsCheckResult pythonPluginResult = currentResultsByKey.get(Language.PYTHON.getPluginKey());
            if (SonarPluginRequirementsChecker.checkForPluginSkipped(pythonPluginResult)) {
                return SonarPluginRequirementsChecker.processUnsatisfiedDependency(currentResult.getPlugin(), Language.PYTHON.getPluginKey());
            }
        }
        return currentResult;
    }

    private static boolean checkForPluginSkipped(@Nullable PluginRequirementsCheckResult plugin) {
        return plugin == null || plugin.isSkipped();
    }

    private static PluginRequirementsCheckResult processUnsatisfiedDependency(PluginInfo plugin, String pluginKeyDependency) {
        LOG.debug("Plugin '{}' dependency on '{}' is unsatisfied. Skip loading it.", (Object)plugin.getName(), (Object)pluginKeyDependency);
        return new PluginRequirementsCheckResult(plugin, new SkipReason.UnsatisfiedDependency(pluginKeyDependency));
    }
}

