/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rule.extractor;

import java.util.Map;
import org.sonar.api.Plugin;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.Version;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.plugin.commons.ApiVersions;
import org.sonarsource.sonarlint.core.plugin.commons.ExtensionInstaller;
import org.sonarsource.sonarlint.core.plugin.commons.ExtensionUtils;
import org.sonarsource.sonarlint.core.plugin.commons.container.SpringComponentContainer;
import org.sonarsource.sonarlint.core.plugin.commons.sonarapi.SonarLintRuntimeImpl;
import org.sonarsource.sonarlint.core.rule.extractor.EmptyConfiguration;
import org.sonarsource.sonarlint.core.rule.extractor.EmptySettings;
import org.sonarsource.sonarlint.core.rule.extractor.NoopTempFolder;
import org.sonarsource.sonarlint.core.rule.extractor.RuleDefinitionsLoader;

public class RulesDefinitionExtractorContainer
extends SpringComponentContainer {
    private RulesDefinition.Context rulesDefinitionContext;
    private final Map<String, Plugin> pluginInstancesByKeys;

    public RulesDefinitionExtractorContainer(Map<String, Plugin> pluginInstancesByKeys) {
        this.pluginInstancesByKeys = pluginInstancesByKeys;
    }

    @Override
    protected void doBeforeStart() {
        Version sonarPluginApiVersion = ApiVersions.loadSonarPluginApiVersion();
        Version sonarlintPluginApiVersion = ApiVersions.loadSonarLintPluginApiVersion();
        SonarLintRuntimeImpl sonarLintRuntime = new SonarLintRuntimeImpl(sonarPluginApiVersion, sonarlintPluginApiVersion, -1L);
        EmptyConfiguration config = new EmptyConfiguration();
        ExtensionInstaller extensionInstaller = new ExtensionInstaller(sonarLintRuntime, config);
        extensionInstaller.install(this, this.pluginInstancesByKeys, (key, ext) -> {
            if (ExtensionUtils.isType(ext, Sensor.class)) {
                return false;
            }
            SonarLintSide annotation = AnnotationUtils.getAnnotation(ext, SonarLintSide.class);
            if (annotation != null) {
                String lifespan = annotation.lifespan();
                return "SINGLE_ANALYSIS".equals(lifespan);
            }
            return false;
        });
        this.add(config, sonarLintRuntime, new SonarQubeVersion(sonarPluginApiVersion), RulesDefinitionXmlLoader.class, RuleDefinitionsLoader.class, NoopTempFolder.class, EmptySettings.class);
    }

    @Override
    protected void doAfterStart() {
        this.rulesDefinitionContext = this.getComponentByType(RuleDefinitionsLoader.class).getContext();
    }

    public RulesDefinition.Context getRulesDefinitionContext() {
        return this.rulesDefinitionContext;
    }
}

