/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.component.Component;
import org.sonarsource.sonarlint.core.serverapi.component.DefaultRemoteProject;
import org.sonarsource.sonarlint.core.serverapi.component.ServerProject;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Components;

public class ComponentApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ServerApiHelper helper;

    public ComponentApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public List<String> getAllFileKeys(String projectKey, ProgressMonitor progress) {
        String path = this.buildAllFileKeysPath(projectKey);
        ArrayList<String> files = new ArrayList<String>();
        this.helper.getPaginated(path, Components.TreeWsResponse::parseFrom, r -> r.getPaging().getTotal(), Components.TreeWsResponse::getComponentsList, component -> files.add(component.getKey()), false, progress);
        return files;
    }

    private String buildAllFileKeysPath(String projectKey) {
        StringBuilder url = new StringBuilder();
        url.append("api/components/tree.protobuf?qualifiers=FIL,UTS&");
        url.append("component=").append(UrlUtils.urlEncode(projectKey));
        this.helper.getOrganizationKey().ifPresent(org -> url.append("&organization=").append(UrlUtils.urlEncode(org)));
        return url.toString();
    }

    public Optional<ServerProject> getProject(String projectKey) {
        return this.fetchComponent(projectKey).map(component -> new DefaultRemoteProject(component.getKey(), component.getName()));
    }

    public List<ServerProject> getAllProjects(ProgressMonitor progress) {
        ArrayList<ServerProject> serverProjects = new ArrayList<ServerProject>();
        this.helper.getPaginated(this.getAllProjectsUrl(), Components.SearchWsResponse::parseFrom, r -> r.getPaging().getTotal(), Components.SearchWsResponse::getComponentsList, project -> serverProjects.add(new DefaultRemoteProject(project.getKey(), project.getName())), true, progress);
        return serverProjects;
    }

    private String getAllProjectsUrl() {
        StringBuilder searchUrl = new StringBuilder();
        searchUrl.append("api/components/search.protobuf?qualifiers=TRK");
        this.helper.getOrganizationKey().ifPresent(org -> searchUrl.append("&organization=").append(UrlUtils.urlEncode(org)));
        return searchUrl.toString();
    }

    private Optional<Component> fetchComponent(String componentKey) {
        return this.fetchComponent(componentKey, response -> {
            Components.Component wsComponent = response.getComponent();
            return new Component(wsComponent.getKey(), wsComponent.getName());
        });
    }

    public Optional<String> fetchFirstAncestorKey(String componentKey) {
        return this.fetchComponent(componentKey, response -> response.getAncestorsList().stream().map(Components.Component::getKey).findFirst().orElse(null));
    }

    private <T> Optional<T> fetchComponent(String componentKey, Function<Components.ShowWsResponse, T> responseConsumer) {
        return ServerApiHelper.processTimed(() -> this.helper.rawGet("api/components/show.protobuf?component=" + UrlUtils.urlEncode(componentKey)), response -> {
            if (response.isSuccessful()) {
                Components.ShowWsResponse wsResponse = Components.ShowWsResponse.parseFrom(response.bodyAsStream());
                return Optional.ofNullable(responseConsumer.apply(wsResponse));
            }
            return Optional.empty();
        }, duration -> LOG.debug("Downloaded project details in {}ms", (Object)duration));
    }
}

