/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push.parsing;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.IssueChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class IssueChangedEventParser
implements EventParser<IssueChangedEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Gson gson = new Gson();

    @Override
    public Optional<IssueChangedEvent> parse(String jsonData) {
        IssueChangedEventPayload payload = this.gson.fromJson(jsonData, IssueChangedEventPayload.class);
        if (payload.isInvalid()) {
            LOG.error("Invalid payload for 'IssueChangedEvent' event: {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new IssueChangedEvent(payload.projectKey, payload.issues.stream().map(issueChange -> issueChange.issueKey).collect(Collectors.toList()), payload.userSeverity != null ? IssueSeverity.valueOf(payload.userSeverity) : null, payload.userType != null ? RuleType.valueOf(payload.userType) : null, payload.resolved));
    }

    private static class IssueChangedEventPayload {
        private String projectKey;
        private List<ChangedIssuePayload> issues;
        private String userSeverity;
        private String userType;
        private Boolean resolved;

        private IssueChangedEventPayload() {
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.projectKey) || ServerApiUtils.isBlank(this.issues) || this.issues.stream().anyMatch(rec$ -> ((ChangedIssuePayload)rec$).isInvalid()) || ServerApiUtils.isBlank(this.userSeverity) && ServerApiUtils.isBlank(this.userType) && this.resolved == null;
        }

        private static class ChangedIssuePayload {
            private String issueKey;
            private String branchName;

            private ChangedIssuePayload() {
            }

            private boolean isInvalid() {
                return ServerApiUtils.isBlank(this.issueKey) || ServerApiUtils.isBlank(this.branchName);
            }
        }
    }
}

