/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push.parsing;

import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.TaintVulnerabilityClosedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class TaintVulnerabilityClosedEventParser
implements EventParser<TaintVulnerabilityClosedEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Gson gson = new Gson();

    @Override
    public Optional<TaintVulnerabilityClosedEvent> parse(String jsonData) {
        TaintVulnerabilityClosedEventPayload payload = this.gson.fromJson(jsonData, TaintVulnerabilityClosedEventPayload.class);
        if (payload.isInvalid()) {
            LOG.error("Invalid payload for 'TaintVulnerabilityClosed' event: {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new TaintVulnerabilityClosedEvent(payload.projectKey, payload.key));
    }

    private static class TaintVulnerabilityClosedEventPayload {
        private String projectKey;
        private String key;

        private TaintVulnerabilityClosedEventPayload() {
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.projectKey) || ServerApiUtils.isBlank(this.key);
        }
    }
}

