/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.rules;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleType;

public class ServerRule {
    private final String name;
    private final String htmlDesc;
    private final List<DescriptionSection> descriptionSections;
    private final String htmlNote;
    private final IssueSeverity severity;
    private final RuleType type;
    private final Language language;
    private final Set<String> educationPrincipleKeys;

    public ServerRule(String name, IssueSeverity severity, RuleType type, String language, String htmlDesc, List<DescriptionSection> descriptionSections, String htmlNote, Set<String> educationPrincipleKeys) {
        this.name = name;
        this.severity = severity;
        this.type = type;
        this.language = Language.forKey(language).orElseThrow(() -> new IllegalArgumentException("Unknown language with key: " + language));
        this.htmlDesc = htmlDesc;
        this.descriptionSections = descriptionSections;
        this.htmlNote = htmlNote;
        this.educationPrincipleKeys = educationPrincipleKeys;
    }

    public String getName() {
        return this.name;
    }

    public String getHtmlDesc() {
        return this.htmlDesc;
    }

    public List<DescriptionSection> getDescriptionSections() {
        return this.descriptionSections;
    }

    public String getHtmlNote() {
        return this.htmlNote;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public RuleType getType() {
        return this.type;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Set<String> getEducationPrincipleKeys() {
        return this.educationPrincipleKeys;
    }

    public static class DescriptionSection {
        private final String key;
        private final String htmlContent;
        private final Optional<Context> context;

        public DescriptionSection(String key, String htmlContent, Optional<Context> context) {
            this.key = key;
            this.htmlContent = htmlContent;
            this.context = context;
        }

        public String getKey() {
            return this.key;
        }

        public String getHtmlContent() {
            return this.htmlContent;
        }

        public Optional<Context> getContext() {
            return this.context;
        }

        public static class Context {
            private final String key;
            private final String displayName;

            public Context(String key, String displayName) {
                this.key = key;
                this.displayName = displayName;
            }

            public String getKey() {
                return this.key;
            }

            public String getDisplayName() {
                return this.displayName;
            }
        }
    }
}

