/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.NewCodeDefinition;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.component.ServerProject;
import org.sonarsource.sonarlint.core.serverapi.hotspot.HotspotApi;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverapi.issue.IssueApi;
import org.sonarsource.sonarlint.core.serverconnection.AnalyzerConfiguration;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.HotspotDownloader;
import org.sonarsource.sonarlint.core.serverconnection.IssueDownloader;
import org.sonarsource.sonarlint.core.serverconnection.IssueStoreReader;
import org.sonarsource.sonarlint.core.serverconnection.LocalStorageSynchronizer;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBinding;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBranches;
import org.sonarsource.sonarlint.core.serverconnection.ProjectStorageUpdateExecutor;
import org.sonarsource.sonarlint.core.serverconnection.ServerHotspotUpdater;
import org.sonarsource.sonarlint.core.serverconnection.ServerInfoSynchronizer;
import org.sonarsource.sonarlint.core.serverconnection.ServerIssueUpdater;
import org.sonarsource.sonarlint.core.serverconnection.StorageFacade;
import org.sonarsource.sonarlint.core.serverconnection.StorageFacadeCache;
import org.sonarsource.sonarlint.core.serverconnection.SynchronizationResult;
import org.sonarsource.sonarlint.core.serverconnection.TaintIssueDownloader;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventsAutoSubscriber;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;
import org.sonarsource.sonarlint.core.serverconnection.prefix.FileTreeMatcher;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FilenameUtils;

public class ServerConnection {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final Version SECRET_ANALYSIS_MIN_SQ_VERSION = Version.create("9.9");
    public static final Version CUSTOM_SECRETS_MIN_SQ_VERSION = Version.create("10.4");
    private static final Version CLEAN_CODE_TAXONOMY_MIN_SQ_VERSION = Version.create("10.2");
    private final Set<Language> enabledLanguagesToSync;
    private final IssueStoreReader issueStoreReader;
    private final LocalStorageSynchronizer storageSynchronizer;
    private final ProjectStorageUpdateExecutor projectStorageUpdateExecutor;
    private final ServerEventsAutoSubscriber serverEventsAutoSubscriber;
    private final ServerIssueUpdater issuesUpdater;
    private final ServerHotspotUpdater hotspotsUpdater;
    private final boolean isSonarCloud;
    private final ServerInfoSynchronizer serverInfoSynchronizer;
    private final ConnectionStorage storage;

    public ServerConnection(Path globalStorageRoot, String connectionId, boolean isSonarCloud, Set<Language> enabledLanguages, Set<String> embeddedPluginKeys, Path workDir) {
        this(StorageFacadeCache.get().getOrCreate(globalStorageRoot, workDir), connectionId, isSonarCloud, enabledLanguages, embeddedPluginKeys);
    }

    public ServerConnection(StorageFacade storageFacade, String connectionId, boolean isSonarCloud, Set<Language> enabledLanguages, Set<String> embeddedPluginKeys) {
        this.isSonarCloud = isSonarCloud;
        this.enabledLanguagesToSync = enabledLanguages.stream().filter(Language::shouldSyncInConnectedMode).collect(Collectors.toCollection(LinkedHashSet::new));
        this.storage = storageFacade.connection(connectionId);
        this.issueStoreReader = new IssueStoreReader(this.storage);
        this.issuesUpdater = new ServerIssueUpdater(this.storage, new IssueDownloader(this.enabledLanguagesToSync), new TaintIssueDownloader(this.enabledLanguagesToSync));
        this.hotspotsUpdater = new ServerHotspotUpdater(this.storage, new HotspotDownloader(this.enabledLanguagesToSync));
        this.serverInfoSynchronizer = new ServerInfoSynchronizer(this.storage);
        this.storageSynchronizer = new LocalStorageSynchronizer(this.enabledLanguagesToSync, embeddedPluginKeys, this.serverInfoSynchronizer, this.storage);
        this.projectStorageUpdateExecutor = new ProjectStorageUpdateExecutor(this.storage);
        this.storage.plugins().cleanUp();
        this.serverEventsAutoSubscriber = new ServerEventsAutoSubscriber(this.storage, this.enabledLanguagesToSync);
    }

    public Map<String, Path> getStoredPluginPathsByKey() {
        return this.storage.plugins().getStoredPluginPathsByKey();
    }

    public AnalyzerConfiguration getAnalyzerConfiguration(String projectKey) {
        return this.storage.project(projectKey).analyzerConfiguration().read();
    }

    public ProjectBranches getProjectBranches(String projectKey) {
        return this.storage.project(projectKey).branches().read();
    }

    public Map<String, ServerProject> downloadAllProjects(EndpointParams endpoint, HttpClient client, ProgressMonitor monitor) {
        try {
            return new ServerApi(endpoint, client).component().getAllProjects(monitor).stream().collect(Collectors.toMap(ServerProject::getKey, p -> p));
        }
        catch (Exception e) {
            LOG.error("Failed to get project list", e);
            return Map.of();
        }
    }

    public SynchronizationResult sync(EndpointParams endpoint, HttpClient client, Set<String> projectKeys, ProgressMonitor monitor) {
        ServerApi serverApi = new ServerApi(new ServerApiHelper(endpoint, client));
        return this.storageSynchronizer.synchronize(serverApi, projectKeys, monitor);
    }

    public List<ServerIssue> getServerIssues(ProjectBinding projectBinding, String branchName, String ideFilePath) {
        return this.issueStoreReader.getServerIssues(projectBinding, branchName, ideFilePath);
    }

    public List<ServerTaintIssue> getServerTaintIssues(ProjectBinding projectBinding, String branchName, String ideFilePath, boolean includeResolved) {
        return this.enhanceWithNewCodeInformation(projectBinding.projectKey(), this.issueStoreReader.getServerTaintIssues(projectBinding, branchName, ideFilePath, includeResolved));
    }

    public List<ServerTaintIssue> getServerTaintIssues(ProjectBinding projectBinding, String branchName) {
        return this.enhanceWithNewCodeInformation(projectBinding.projectKey(), this.issueStoreReader.getRawServerTaintIssues(projectBinding, branchName));
    }

    private List<ServerTaintIssue> enhanceWithNewCodeInformation(String projectKey, List<ServerTaintIssue> issues) {
        Optional<NewCodeDefinition> newCodeDefinition = this.storage.project(projectKey).newCodeDefinition().read();
        issues.forEach(taintIssue -> taintIssue.setIsOnNewCode(newCodeDefinition.map(definition -> definition.isOnNewCode(taintIssue.getCreationDate().toEpochMilli())).orElse(true)));
        return issues;
    }

    public void subscribeForEvents(EndpointParams endpoint, HttpClient client, Set<String> projectKeys, Consumer<ServerEvent> clientEventConsumer) {
        this.serverEventsAutoSubscriber.subscribePermanently(new ServerApi(new ServerApiHelper(endpoint, client)), projectKeys, clientEventConsumer);
    }

    public ProjectBinding calculatePathPrefixes(String projectKey, Collection<String> ideFilePaths) {
        List<Path> idePathList = ideFilePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        List<Path> sqPathList = this.storage.project(projectKey).components().read().getComponentList().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        FileTreeMatcher fileMatcher = new FileTreeMatcher();
        FileTreeMatcher.Result match = fileMatcher.match(sqPathList, idePathList);
        return new ProjectBinding(projectKey, FilenameUtils.separatorsToUnix(match.sqPrefix().toString()), FilenameUtils.separatorsToUnix(match.idePrefix().toString()));
    }

    public void downloadServerIssuesForFile(EndpointParams endpoint, HttpClient client, ProjectBinding projectBinding, String ideFilePath, String branchName) {
        ServerApi serverApi = new ServerApi(new ServerApiHelper(endpoint, client));
        Version serverVersion = this.readOrSynchronizeServerVersion(serverApi);
        this.issuesUpdater.updateFileIssues(serverApi, projectBinding, ideFilePath, branchName, this.isSonarCloud, serverVersion);
    }

    public void downloadServerIssuesForFile(ServerApi serverApi, String projectKey, String serverFileRelativePath, String branchName) {
        Version serverVersion = this.readOrSynchronizeServerVersion(serverApi);
        this.issuesUpdater.updateFileIssues(serverApi, projectKey, serverFileRelativePath, branchName, this.isSonarCloud, serverVersion);
    }

    public void downloadServerTaintIssuesForFile(EndpointParams endpoint, HttpClient client, ProjectBinding projectBinding, String ideFilePath, String branchName, ProgressMonitor progress) {
        ServerApi serverApi = new ServerApi(new ServerApiHelper(endpoint, client));
        Version serverVersion = this.readOrSynchronizeServerVersion(serverApi);
        this.issuesUpdater.updateFileTaints(serverApi, projectBinding, ideFilePath, branchName, this.isSonarCloud, serverVersion, progress);
    }

    public Version readOrSynchronizeServerVersion(ServerApi serverApi) {
        return this.serverInfoSynchronizer.readOrSynchronizeServerInfo(serverApi).getVersion();
    }

    public void downloadServerIssuesForProject(EndpointParams endpoint, HttpClient client, String projectKey, String branchName) {
        this.downloadServerIssuesForProject(new ServerApi(new ServerApiHelper(endpoint, client)), projectKey, branchName);
    }

    public void downloadServerIssuesForProject(ServerApi serverApi, String projectKey, String branchName) {
        Version serverVersion = this.readOrSynchronizeServerVersion(serverApi);
        this.issuesUpdater.update(serverApi, projectKey, branchName, this.isSonarCloud, serverVersion);
    }

    public void downloadAllServerHotspots(EndpointParams endpoint, HttpClient client, String projectKey, String branchName, ProgressMonitor progress) {
        this.downloadAllServerHotspots(new ServerApi(new ServerApiHelper(endpoint, client)), projectKey, branchName, progress);
    }

    public void downloadAllServerHotspots(ServerApi serverApi, String projectKey, String branchName, ProgressMonitor progress) {
        this.hotspotsUpdater.updateAll(serverApi.hotspot(), projectKey, branchName, () -> this.readOrSynchronizeServerVersion(serverApi), progress);
    }

    public void downloadAllServerHotspotsForFile(EndpointParams endpoint, HttpClient client, ProjectBinding projectBinding, String ideFilePath, String branchName) {
        ServerApi serverApi = new ServerApi(new ServerApiHelper(endpoint, client));
        this.hotspotsUpdater.updateForFile(serverApi.hotspot(), projectBinding, ideFilePath, branchName, () -> this.readOrSynchronizeServerVersion(serverApi));
    }

    public void downloadAllServerHotspotsForFile(ServerApi serverApi, String projectKey, String serverRelativeFilePath, String branchName) {
        this.hotspotsUpdater.updateForFile(serverApi.hotspot(), projectKey, serverRelativeFilePath, branchName, () -> this.readOrSynchronizeServerVersion(serverApi));
    }

    public Collection<ServerHotspot> getServerHotspots(ProjectBinding projectBinding, String branchName, String ideFilePath) {
        return this.issueStoreReader.getServerHotspots(projectBinding, branchName, ideFilePath);
    }

    public boolean permitsHotspotTracking() {
        return this.storage.serverInfo().read().map(serverInfo -> HotspotApi.permitsTracking(this.isSonarCloud, serverInfo::getVersion)).orElse(false);
    }

    public boolean supportsSecretAnalysis() {
        return this.isSonarCloud || this.compareSynchronizedServerVersion(SECRET_ANALYSIS_MIN_SQ_VERSION, i -> i >= 0);
    }

    public boolean supportsCustomSecrets() {
        return !this.isSonarCloud && this.compareSynchronizedServerVersion(CUSTOM_SECRETS_MIN_SQ_VERSION, i -> i >= 0);
    }

    public boolean shouldSkipCleanCodeTaxonomy() {
        return !this.isSonarCloud && this.compareSynchronizedServerVersion(CLEAN_CODE_TAXONOMY_MIN_SQ_VERSION, i -> i < 0);
    }

    private boolean compareSynchronizedServerVersion(Version version, IntPredicate comparisonPredicate) {
        return this.storage.serverInfo().read().map(serverInfo -> serverInfo.getVersion().compareToIgnoreQualifier(version)).map(comparisonPredicate::test).orElse(false);
    }

    public void syncServerIssuesForProject(EndpointParams endpoint, HttpClient client, String projectKey, String branchName) {
        this.syncServerIssuesForProject(new ServerApi(new ServerApiHelper(endpoint, client)), projectKey, branchName);
    }

    public void syncServerIssuesForProject(ServerApi serverApi, String projectKey, String branchName) {
        Version serverVersion = this.readOrSynchronizeServerVersion(serverApi);
        if (IssueApi.supportIssuePull(this.isSonarCloud, serverVersion)) {
            LOG.info("[SYNC] Synchronizing issues for project '{}' on branch '{}'", (Object)projectKey, (Object)branchName);
            this.issuesUpdater.sync(serverApi, projectKey, branchName, this.enabledLanguagesToSync);
        } else {
            LOG.debug("Incremental issue sync is not supported. Skipping.");
        }
    }

    public void syncServerTaintIssuesForProject(EndpointParams endpoint, HttpClient client, String projectKey, String branchName) {
        this.syncServerTaintIssuesForProject(new ServerApi(new ServerApiHelper(endpoint, client)), projectKey, branchName);
    }

    public void syncServerTaintIssuesForProject(ServerApi serverApi, String projectKey, String branchName) {
        Version serverVersion = this.readOrSynchronizeServerVersion(serverApi);
        if (IssueApi.supportIssuePull(this.isSonarCloud, serverVersion)) {
            LOG.info("[SYNC] Synchronizing taint issues for project '{}' on branch '{}'", (Object)projectKey, (Object)branchName);
            this.issuesUpdater.syncTaints(serverApi, projectKey, branchName, this.enabledLanguagesToSync);
        } else {
            LOG.debug("Incremental taint issue sync is not supported. Skipping.");
        }
    }

    public void syncServerHotspotsForProject(EndpointParams endpoint, HttpClient client, String projectKey, String branchName) {
        this.syncServerHotspotsForProject(new ServerApi(new ServerApiHelper(endpoint, client)), projectKey, branchName);
    }

    public void syncServerHotspotsForProject(ServerApi serverApi, String projectKey, String branchName) {
        Version serverVersion = this.readOrSynchronizeServerVersion(serverApi);
        if (HotspotApi.supportHotspotsPull(this.isSonarCloud, serverVersion)) {
            LOG.info("[SYNC] Synchronizing hotspots for project '{}' on branch '{}'", (Object)projectKey, (Object)branchName);
            this.hotspotsUpdater.sync(serverApi.hotspot(), projectKey, branchName, this.enabledLanguagesToSync);
        } else {
            LOG.debug("Incremental hotspot sync is not supported. Skipping.");
        }
    }

    public void updateProject(EndpointParams endpoint, HttpClient client, String projectKey, ProgressMonitor monitor) {
        this.projectStorageUpdateExecutor.update(new ServerApi(new ServerApiHelper(endpoint, client)), projectKey, monitor);
    }

    public void stop(boolean deleteStorage) {
        this.serverEventsAutoSubscriber.stop();
    }
}

