/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import com.google.protobuf.Message;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.system.ServerInfo;
import org.sonarsource.sonarlint.core.serverconnection.FileUtils;
import org.sonarsource.sonarlint.core.serverconnection.StoredServerInfo;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProtobufFileUtil;
import org.sonarsource.sonarlint.core.serverconnection.storage.RWLock;

public class ServerInfoStorage {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final String SERVER_INFO_PB = "server_info.pb";
    private final Path storageFilePath;
    private final RWLock rwLock = new RWLock();

    public ServerInfoStorage(Path rootPath) {
        this.storageFilePath = rootPath.resolve(SERVER_INFO_PB);
    }

    public void store(ServerInfo serverInfo) {
        FileUtils.mkdirs(this.storageFilePath.getParent());
        Sonarlint.ServerInfo serverInfoToStore = ServerInfoStorage.adapt(serverInfo);
        LOG.debug("Storing server info in {}", (Object)this.storageFilePath);
        this.rwLock.write(() -> ProtobufFileUtil.writeToFile((Message)serverInfoToStore, this.storageFilePath));
    }

    public Optional<StoredServerInfo> read() {
        return this.rwLock.read(() -> Files.exists(this.storageFilePath, new LinkOption[0]) ? Optional.of(ServerInfoStorage.adapt(ProtobufFileUtil.readFile(this.storageFilePath, Sonarlint.ServerInfo.parser()))) : Optional.empty());
    }

    private static Sonarlint.ServerInfo adapt(ServerInfo serverInfo) {
        return Sonarlint.ServerInfo.newBuilder().setVersion(serverInfo.getVersion()).build();
    }

    private static StoredServerInfo adapt(Sonarlint.ServerInfo serverInfo) {
        return new StoredServerInfo(Version.create(serverInfo.getVersion()));
    }
}

