/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.util.CompressBackupUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.TextRange;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverapi.util.ProtobufUtil;
import org.sonarsource.sonarlint.core.serverconnection.issues.FileLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.LineLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.RangeLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerFinding;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.HotspotReviewStatusBinding;
import org.sonarsource.sonarlint.core.serverconnection.storage.InstantBinding;
import org.sonarsource.sonarlint.core.serverconnection.storage.IssueSeverityBinding;
import org.sonarsource.sonarlint.core.serverconnection.storage.IssueTypeBinding;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectServerIssueStore;
import org.sonarsource.sonarlint.core.serverconnection.storage.StorageUtils;
import org.sonarsource.sonarlint.core.serverconnection.storage.TarGzUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils;

public class XodusServerIssueStore
implements ProjectServerIssueStore {
    static final int CURRENT_SCHEMA_VERSION = 1;
    private static final String BACKUP_TAR_GZ = "backup.tar.gz";
    private static final String HOTSPOTS = "hotspots";
    private static final String ISSUES = "issues";
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String BRANCH_ENTITY_TYPE = "Branch";
    private static final String FILE_ENTITY_TYPE = "File";
    private static final String ISSUE_ENTITY_TYPE = "Issue";
    private static final String TAINT_ISSUE_ENTITY_TYPE = "TaintIssue";
    private static final String HOTSPOT_ENTITY_TYPE = "Hotspot";
    private static final String SCHEMA_ENTITY_TYPE = "Schema";
    private static final String BRANCH_TO_FILES_LINK_NAME = "files";
    private static final String BRANCH_TO_TAINT_ISSUES_LINK_NAME = "taintIssues";
    private static final String TAINT_ISSUE_TO_BRANCH_LINK_NAME = "branch";
    private static final String FILE_TO_ISSUES_LINK_NAME = "issues";
    private static final String FILE_TO_TAINT_ISSUES_LINK_NAME = "taintIssues";
    private static final String FILE_TO_HOTSPOTS_LINK_NAME = "hotspots";
    private static final String ISSUE_TO_FILE_LINK_NAME = "file";
    private static final String START_LINE_PROPERTY_NAME = "startLine";
    private static final String START_LINE_OFFSET_PROPERTY_NAME = "startLineOffset";
    private static final String END_LINE_PROPERTY_NAME = "endLine";
    private static final String END_LINE_OFFSET_PROPERTY_NAME = "endLineOffset";
    private static final String KEY_PROPERTY_NAME = "key";
    private static final String RESOLVED_PROPERTY_NAME = "resolved";
    private static final String REVIEW_STATUS_PROPERTY_NAME = "status";
    private static final String RULE_KEY_PROPERTY_NAME = "ruleKey";
    private static final String LINE_HASH_PROPERTY_NAME = "lineHash";
    private static final String RANGE_HASH_PROPERTY_NAME = "rangeHash";
    private static final String CREATION_DATE_PROPERTY_NAME = "creationDate";
    private static final String USER_SEVERITY_PROPERTY_NAME = "userSeverity";
    private static final String SEVERITY_PROPERTY_NAME = "severity";
    private static final String VULNERABILITY_PROBABILITY_PROPERTY_NAME = "vulnerabilityProbability";
    private static final String TYPE_PROPERTY_NAME = "type";
    private static final String PATH_PROPERTY_NAME = "path";
    private static final String NAME_PROPERTY_NAME = "name";
    private static final String LAST_ISSUE_SYNC_PROPERTY_NAME = "lastIssueSync";
    private static final String LAST_ISSUE_ENABLED_LANGUAGES = "lastIssueEnabledLanguages";
    private static final String LAST_TAINT_ENABLED_LANGUAGES = "lastTaintEnabledLanguages";
    private static final String LAST_HOTSPOT_ENABLED_LANGUAGES = "lastHotspotEnabledLanguages";
    private static final String LAST_TAINT_SYNC_PROPERTY_NAME = "lastTaintSync";
    private static final String LAST_HOTSPOT_SYNC_PROPERTY_NAME = "lastHotspotSync";
    private static final String VERSION_PROPERTY_NAME = "version";
    private static final String MESSAGE_BLOB_NAME = "message";
    private static final String FLOWS_BLOB_NAME = "flows";
    private static final String RULE_DESCRIPTION_CONTEXT_KEY_PROPERTY_NAME = "ruleDescriptionContextKey";
    private static final String CLEAN_CODE_ATTRIBUTE_PROPERTY_NAME = "cleanCodeAttribute";
    private static final String IMPACTS_BLOB_NAME = "impacts";
    private static final String ASSIGNEE_PROPERTY_NAME = "assignee";
    private final PersistentEntityStore entityStore;
    private final Path backupFile;
    private final Path xodusDbDir;

    public XodusServerIssueStore(Path backupDir, Path workDir) throws IOException {
        this(backupDir, workDir, XodusServerIssueStore::checkCurrentSchemaVersion);
    }

    XodusServerIssueStore(Path backupDir, Path workDir, StoreTransactionalExecutable afterInit) throws IOException {
        this.xodusDbDir = Files.createTempDirectory(workDir, "xodus-issue-store", new FileAttribute[0]);
        this.backupFile = backupDir.resolve(BACKUP_TAR_GZ);
        if (Files.isRegularFile(this.backupFile, new LinkOption[0])) {
            LOG.debug("Restoring previous server issue database from {}", (Object)this.backupFile);
            try {
                TarGzUtils.extractTarGz(this.backupFile, this.xodusDbDir);
            }
            catch (Exception e) {
                LOG.error("Unable to restore backup {}", (Object)this.backupFile);
            }
        }
        LOG.debug("Starting server issue database from {}", (Object)this.xodusDbDir);
        this.entityStore = this.buildEntityStore();
        this.entityStore.executeInTransaction(txn -> {
            this.entityStore.registerCustomPropertyType(txn, IssueSeverity.class, (ComparableBinding)new IssueSeverityBinding());
            this.entityStore.registerCustomPropertyType(txn, RuleType.class, (ComparableBinding)new IssueTypeBinding());
            this.entityStore.registerCustomPropertyType(txn, Instant.class, (ComparableBinding)new InstantBinding());
            this.entityStore.registerCustomPropertyType(txn, HotspotReviewStatus.class, (ComparableBinding)new HotspotReviewStatusBinding());
        });
        this.entityStore.executeInExclusiveTransaction(afterInit);
    }

    private PersistentEntityStore buildEntityStore() {
        Environment environment = Environments.newInstance((File)this.xodusDbDir.toAbsolutePath().toFile(), (EnvironmentConfig)new EnvironmentConfig().setLogAllowRemote(true).setLogAllowRemovable(true).setLogAllowRamDisk(true));
        PersistentEntityStoreImpl entityStoreImpl = PersistentEntityStores.newInstance((Environment)environment);
        entityStoreImpl.setCloseEnvironment(true);
        return entityStoreImpl;
    }

    private static ServerIssue adapt(Entity storedIssue) {
        String filePath = (String)((Object)Objects.requireNonNull(storedIssue.getLink(ISSUE_TO_FILE_LINK_NAME).getProperty(PATH_PROPERTY_NAME)));
        Comparable startLine = storedIssue.getProperty(START_LINE_PROPERTY_NAME);
        String key = (String)((Object)Objects.requireNonNull(storedIssue.getProperty(KEY_PROPERTY_NAME)));
        boolean resolved = Boolean.TRUE.equals(storedIssue.getProperty(RESOLVED_PROPERTY_NAME));
        String ruleKey = (String)((Object)Objects.requireNonNull(storedIssue.getProperty(RULE_KEY_PROPERTY_NAME)));
        String msg = Objects.requireNonNull(storedIssue.getBlobString(MESSAGE_BLOB_NAME));
        Instant creationDate = (Instant)Objects.requireNonNull(storedIssue.getProperty(CREATION_DATE_PROPERTY_NAME));
        IssueSeverity userSeverity = (IssueSeverity)((Object)storedIssue.getProperty(USER_SEVERITY_PROPERTY_NAME));
        RuleType type = (RuleType)((Object)Objects.requireNonNull(storedIssue.getProperty(TYPE_PROPERTY_NAME)));
        if (startLine == null) {
            return new FileLevelServerIssue(key, resolved, ruleKey, msg, filePath, creationDate, userSeverity, type);
        }
        String rangeHash = storedIssue.getBlobString(RANGE_HASH_PROPERTY_NAME);
        if (rangeHash != null) {
            Integer startLineOffset = (Integer)storedIssue.getProperty(START_LINE_OFFSET_PROPERTY_NAME);
            Integer endLine = (Integer)storedIssue.getProperty(END_LINE_PROPERTY_NAME);
            Integer endLineOffset = (Integer)storedIssue.getProperty(END_LINE_OFFSET_PROPERTY_NAME);
            TextRangeWithHash textRange = new TextRangeWithHash((Integer)startLine, startLineOffset, endLine, endLineOffset, rangeHash);
            return new RangeLevelServerIssue(key, resolved, ruleKey, msg, filePath, creationDate, userSeverity, type, textRange);
        }
        return new LineLevelServerIssue(key, resolved, ruleKey, msg, storedIssue.getBlobString(LINE_HASH_PROPERTY_NAME), filePath, creationDate, userSeverity, type, (Integer)storedIssue.getProperty(START_LINE_PROPERTY_NAME));
    }

    private static ServerTaintIssue adaptTaint(Entity storedIssue) {
        String filePath = (String)((Object)Objects.requireNonNull(storedIssue.getLink(ISSUE_TO_FILE_LINK_NAME).getProperty(PATH_PROPERTY_NAME)));
        Integer startLine = (Integer)storedIssue.getProperty(START_LINE_PROPERTY_NAME);
        TextRangeWithHash textRange = null;
        if (startLine != null) {
            Integer startLineOffset = (Integer)storedIssue.getProperty(START_LINE_OFFSET_PROPERTY_NAME);
            Integer endLine = (Integer)storedIssue.getProperty(END_LINE_PROPERTY_NAME);
            Integer endLineOffset = (Integer)storedIssue.getProperty(END_LINE_OFFSET_PROPERTY_NAME);
            String hash = storedIssue.getBlobString(RANGE_HASH_PROPERTY_NAME);
            textRange = new TextRangeWithHash(startLine, startLineOffset, endLine, endLineOffset, hash);
        }
        String cleanCodeAttribute = (String)((Object)storedIssue.getProperty(CLEAN_CODE_ATTRIBUTE_PROPERTY_NAME));
        return new ServerTaintIssue((String)((Object)Objects.requireNonNull(storedIssue.getProperty(KEY_PROPERTY_NAME))), Boolean.TRUE.equals(storedIssue.getProperty(RESOLVED_PROPERTY_NAME)), (String)((Object)Objects.requireNonNull(storedIssue.getProperty(RULE_KEY_PROPERTY_NAME))), Objects.requireNonNull(storedIssue.getBlobString(MESSAGE_BLOB_NAME)), filePath, (Instant)Objects.requireNonNull(storedIssue.getProperty(CREATION_DATE_PROPERTY_NAME)), (IssueSeverity)((Object)Objects.requireNonNull(storedIssue.getProperty(SEVERITY_PROPERTY_NAME))), (RuleType)((Object)Objects.requireNonNull(storedIssue.getProperty(TYPE_PROPERTY_NAME))), textRange, (String)((Object)storedIssue.getProperty(RULE_DESCRIPTION_CONTEXT_KEY_PROPERTY_NAME)), Optional.ofNullable(cleanCodeAttribute).map(CleanCodeAttribute::valueOf).orElse(null), XodusServerIssueStore.readImpacts(storedIssue.getBlob(IMPACTS_BLOB_NAME))).setFlows(XodusServerIssueStore.readFlows(storedIssue.getBlob(FLOWS_BLOB_NAME)));
    }

    private static ServerHotspot adaptHotspot(Entity storedHotspot) {
        String filePath = (String)((Object)Objects.requireNonNull(storedHotspot.getLink(ISSUE_TO_FILE_LINK_NAME).getProperty(PATH_PROPERTY_NAME)));
        Integer startLine = (Integer)storedHotspot.getProperty(START_LINE_PROPERTY_NAME);
        Integer startLineOffset = (Integer)storedHotspot.getProperty(START_LINE_OFFSET_PROPERTY_NAME);
        Integer endLine = (Integer)storedHotspot.getProperty(END_LINE_PROPERTY_NAME);
        Integer endLineOffset = (Integer)storedHotspot.getProperty(END_LINE_OFFSET_PROPERTY_NAME);
        String hash = (String)((Object)storedHotspot.getProperty(RANGE_HASH_PROPERTY_NAME));
        TextRange textRange = hash != null && !hash.isEmpty() ? new TextRangeWithHash(startLine, startLineOffset, endLine, endLineOffset, hash) : new TextRange(startLine, startLineOffset, endLine, endLineOffset);
        VulnerabilityProbability vulnerabilityProbability = VulnerabilityProbability.valueOf((String)((Object)storedHotspot.getProperty(VULNERABILITY_PROBABILITY_PROPERTY_NAME)));
        String assignee = (String)((Object)storedHotspot.getProperty(ASSIGNEE_PROPERTY_NAME));
        HotspotReviewStatus status = (HotspotReviewStatus)((Object)storedHotspot.getProperty(REVIEW_STATUS_PROPERTY_NAME));
        if (status == null) {
            boolean resolved = Boolean.TRUE.equals(storedHotspot.getProperty(RESOLVED_PROPERTY_NAME));
            status = resolved ? HotspotReviewStatus.SAFE : HotspotReviewStatus.TO_REVIEW;
        }
        return new ServerHotspot((String)((Object)Objects.requireNonNull(storedHotspot.getProperty(KEY_PROPERTY_NAME))), (String)((Object)Objects.requireNonNull(storedHotspot.getProperty(RULE_KEY_PROPERTY_NAME))), Objects.requireNonNull(storedHotspot.getBlobString(MESSAGE_BLOB_NAME)), filePath, textRange, (Instant)Objects.requireNonNull(storedHotspot.getProperty(CREATION_DATE_PROPERTY_NAME)), status, vulnerabilityProbability, assignee);
    }

    private static List<ServerTaintIssue.Flow> readFlows(@Nullable InputStream blob) {
        if (blob == null) {
            return List.of();
        }
        return ProtobufUtil.readMessages(blob, Sonarlint.Flow.parser()).stream().map(XodusServerIssueStore::toJavaFlow).collect(Collectors.toList());
    }

    private static Map<SoftwareQuality, ImpactSeverity> readImpacts(@Nullable InputStream blob) {
        if (blob == null) {
            return Map.of();
        }
        return ProtobufUtil.readMessages(blob, Sonarlint.Impact.parser()).stream().map(XodusServerIssueStore::toJavaImpact).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public List<ServerIssue> load(String branchName, String filePath) {
        return this.loadIssue(branchName, filePath, "issues", XodusServerIssueStore::adapt);
    }

    @Override
    public List<ServerTaintIssue> loadTaint(String branchName, String filePath) {
        return this.loadIssue(branchName, filePath, "taintIssues", XodusServerIssueStore::adaptTaint);
    }

    @Override
    public Collection<ServerHotspot> loadHotspots(String branchName, String serverFilePath) {
        return this.loadIssue(branchName, serverFilePath, "hotspots", XodusServerIssueStore::adaptHotspot);
    }

    private <G> List<G> loadIssue(String branchName, String filePath, String linkName, Function<Entity, G> adapter) {
        return (List)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> branch.getLinks(BRANCH_TO_FILES_LINK_NAME)).flatMap(files -> XodusServerIssueStore.findUniqueAmong(files, PATH_PROPERTY_NAME, filePath)).map(fileToLoad -> fileToLoad.getLinks(linkName)).map(issueEntities -> StreamSupport.stream(issueEntities.spliterator(), false).map(adapter).collect(Collectors.toList())).orElseGet(Collections::emptyList));
    }

    @Override
    public List<ServerTaintIssue> loadTaint(String branchName) {
        return (List)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> StreamSupport.stream(branch.getLinks("taintIssues").spliterator(), false).map(XodusServerIssueStore::adaptTaint).collect(Collectors.toList())).orElseGet(Collections::emptyList));
    }

    @Override
    public void replaceAllIssuesOfFile(String branchName, String serverFilePath, List<ServerIssue> issues) {
        XodusServerIssueStore.timed(XodusServerIssueStore.wroteMessage(issues.size(), "issues"), () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, serverFilePath, txn);
            XodusServerIssueStore.replaceAllIssuesOfFile(issues, txn, fileEntity);
        }));
    }

    @Override
    public void mergeIssues(String branchName, List<ServerIssue> issuesToMerge, Set<String> closedIssueKeysToDelete, Instant syncTimestamp, Set<Language> enabledLanguages) {
        Map<String, List<ServerIssue>> issuesByFilePath = issuesToMerge.stream().collect(Collectors.groupingBy(ServerIssue::getFilePath));
        XodusServerIssueStore.timed(XodusServerIssueStore.mergedMessage(issuesToMerge.size(), closedIssueKeysToDelete.size(), "issues"), () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            issuesByFilePath.forEach((filePath, issues) -> {
                Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, filePath, txn);
                issues.forEach(issue -> XodusServerIssueStore.updateOrCreateIssue(fileEntity, issue, txn));
                txn.flush();
            });
            closedIssueKeysToDelete.forEach(issueKey -> XodusServerIssueStore.remove(issueKey, txn));
            branch.setProperty(LAST_ISSUE_SYNC_PROPERTY_NAME, (Comparable)syncTimestamp);
            String serializedLanguages = XodusServerIssueStore.getSerializedLanguages(enabledLanguages);
            branch.setProperty(LAST_ISSUE_ENABLED_LANGUAGES, (Comparable)((Object)serializedLanguages));
        }));
    }

    @Override
    public void mergeTaintIssues(String branchName, List<ServerTaintIssue> issuesToMerge, Set<String> closedIssueKeysToDelete, Instant syncTimestamp, Set<Language> enabledLanguages) {
        Map<String, List<ServerTaintIssue>> issuesByFilePath = issuesToMerge.stream().collect(Collectors.groupingBy(ServerTaintIssue::getFilePath));
        XodusServerIssueStore.timed(XodusServerIssueStore.mergedMessage(issuesToMerge.size(), closedIssueKeysToDelete.size(), "taint issues"), () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            issuesByFilePath.forEach((filePath, issues) -> {
                Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, filePath, txn);
                issues.forEach(issue -> XodusServerIssueStore.updateOrCreateTaintIssue(branch, fileEntity, issue, txn));
                txn.flush();
            });
            closedIssueKeysToDelete.forEach(issueKey -> XodusServerIssueStore.removeTaint(issueKey, txn));
            branch.setProperty(LAST_TAINT_SYNC_PROPERTY_NAME, (Comparable)syncTimestamp);
            String serializedLanguages = XodusServerIssueStore.getSerializedLanguages(enabledLanguages);
            branch.setProperty(LAST_TAINT_ENABLED_LANGUAGES, (Comparable)((Object)serializedLanguages));
        }));
    }

    @Override
    public void mergeHotspots(String branchName, List<ServerHotspot> hotspotsToMerge, Set<String> closedHotspotKeysToDelete, Instant syncTimestamp, Set<Language> enabledLanguages) {
        Map<String, List<ServerHotspot>> hotspotsByFilePath = hotspotsToMerge.stream().collect(Collectors.groupingBy(ServerHotspot::getFilePath));
        XodusServerIssueStore.timed(XodusServerIssueStore.mergedMessage(hotspotsToMerge.size(), closedHotspotKeysToDelete.size(), "hotspots"), () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            hotspotsByFilePath.forEach((filePath, hotspots) -> {
                Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, filePath, txn);
                hotspots.forEach(hotspot -> XodusServerIssueStore.updateOrCreateHotspot(fileEntity, hotspot, txn));
                txn.flush();
            });
            closedHotspotKeysToDelete.forEach(hotspotKey -> XodusServerIssueStore.removeHotspot(hotspotKey, txn));
            branch.setProperty(LAST_HOTSPOT_SYNC_PROPERTY_NAME, (Comparable)syncTimestamp);
            String serializedLanguages = XodusServerIssueStore.getSerializedLanguages(enabledLanguages);
            branch.setProperty(LAST_HOTSPOT_ENABLED_LANGUAGES, (Comparable)((Object)serializedLanguages));
        }));
    }

    private static String wroteMessage(int wrote, String itemName) {
        return String.format("Wrote %d %s in store", wrote, itemName);
    }

    private static String mergedMessage(int merged, int closed, String itemName) {
        return String.format("Merged %d %s in store. Closed %d.", merged, itemName, closed);
    }

    @Override
    public Optional<Instant> getLastIssueSyncTimestamp(String branchName) {
        return (Optional)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> (Instant)branch.getProperty(LAST_ISSUE_SYNC_PROPERTY_NAME)));
    }

    @Override
    public Set<Language> getLastIssueEnabledLanguages(String branchName) {
        Optional lastEnabledLanguages = (Optional)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> (String)((Object)branch.getProperty(LAST_ISSUE_ENABLED_LANGUAGES))));
        return StorageUtils.deserializeLanguages(lastEnabledLanguages);
    }

    @Override
    public Set<Language> getLastTaintEnabledLanguages(String branchName) {
        Optional lastEnabledLanguages = (Optional)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> (String)((Object)branch.getProperty(LAST_TAINT_ENABLED_LANGUAGES))));
        return StorageUtils.deserializeLanguages(lastEnabledLanguages);
    }

    @Override
    public Set<Language> getLastHotspotEnabledLanguages(String branchName) {
        Optional lastEnabledLanguages = (Optional)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> (String)((Object)branch.getProperty(LAST_HOTSPOT_ENABLED_LANGUAGES))));
        return StorageUtils.deserializeLanguages(lastEnabledLanguages);
    }

    @Override
    public Optional<Instant> getLastTaintSyncTimestamp(String branchName) {
        return (Optional)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> (Instant)branch.getProperty(LAST_TAINT_SYNC_PROPERTY_NAME)));
    }

    @Override
    public Optional<Instant> getLastHotspotSyncTimestamp(String branchName) {
        return (Optional)this.entityStore.computeInReadonlyTransaction(txn -> XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).map(branch -> (Instant)branch.getProperty(LAST_HOTSPOT_SYNC_PROPERTY_NAME)));
    }

    @Override
    public void replaceAllIssuesOfBranch(String branchName, List<ServerIssue> issues) {
        Map<String, List<ServerIssue>> issuesByFile = issues.stream().collect(Collectors.groupingBy(ServerIssue::getFilePath));
        XodusServerIssueStore.timed(XodusServerIssueStore.wroteMessage(issues.size(), "issues"), () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            branch.getLinks(BRANCH_TO_FILES_LINK_NAME).forEach(fileEntity -> {
                Comparable entityFilePath = fileEntity.getProperty(PATH_PROPERTY_NAME);
                if (!issuesByFile.containsKey(entityFilePath)) {
                    XodusServerIssueStore.deleteAllIssuesOfFile(txn, fileEntity);
                }
            });
            txn.flush();
            issuesByFile.forEach((filePath, fileIssues) -> {
                Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, filePath, txn);
                XodusServerIssueStore.replaceAllIssuesOfFile(fileIssues, txn, fileEntity);
                txn.flush();
            });
        }));
    }

    @Override
    public void replaceAllHotspotsOfBranch(String branchName, Collection<ServerHotspot> serverHotspots) {
        Map<String, List<ServerHotspot>> hotspotsByFile = serverHotspots.stream().collect(Collectors.groupingBy(ServerHotspot::getFilePath));
        XodusServerIssueStore.timed(XodusServerIssueStore.wroteMessage(serverHotspots.size(), "hotspots"), () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            branch.getLinks(BRANCH_TO_FILES_LINK_NAME).forEach(fileEntity -> {
                Comparable entityFilePath = fileEntity.getProperty(PATH_PROPERTY_NAME);
                if (!hotspotsByFile.containsKey(entityFilePath)) {
                    XodusServerIssueStore.deleteAllHotspotsOfFile(txn, fileEntity);
                }
            });
            txn.flush();
            hotspotsByFile.forEach((filePath, fileIssues) -> {
                Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, filePath, txn);
                XodusServerIssueStore.replaceAllHotspotsOfFile(fileIssues, txn, fileEntity);
                txn.flush();
            });
        }));
    }

    @Override
    public void replaceAllHotspotsOfFile(String branchName, String serverFilePath, Collection<ServerHotspot> serverHotspots) {
        XodusServerIssueStore.timed(XodusServerIssueStore.wroteMessage(serverHotspots.size(), "hotspots"), () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, serverFilePath, txn);
            XodusServerIssueStore.replaceAllHotspotsOfFile(serverHotspots, txn, fileEntity);
        }));
    }

    @Override
    public boolean changeHotspotStatus(String hotspotKey, HotspotReviewStatus newStatus) {
        return (Boolean)this.entityStore.computeInTransaction(txn -> {
            Optional<Entity> optionalEntity = XodusServerIssueStore.findUnique(txn, HOTSPOT_ENTITY_TYPE, KEY_PROPERTY_NAME, hotspotKey);
            if (optionalEntity.isPresent()) {
                Entity hotspotEntity = optionalEntity.get();
                hotspotEntity.setProperty(REVIEW_STATUS_PROPERTY_NAME, (Comparable)((Object)newStatus));
                return true;
            }
            return false;
        });
    }

    private static void replaceAllHotspotsOfFile(Collection<ServerHotspot> hotspots, @NotNull StoreTransaction txn, Entity fileEntity) {
        fileEntity.getLinks("hotspots").forEach(Entity::delete);
        fileEntity.deleteLinks("hotspots");
        hotspots.forEach(hotspot -> XodusServerIssueStore.updateOrCreateHotspot(fileEntity, hotspot, txn));
    }

    private static String getSerializedLanguages(Set<Language> enabledLanguages) {
        return enabledLanguages.stream().map(Language::getLanguageKey).collect(Collectors.joining(","));
    }

    private static void updateOrCreateHotspot(Entity fileEntity, ServerHotspot hotspot, StoreTransaction transaction) {
        Entity hotspotEntity = XodusServerIssueStore.updateOrCreateIssueCommon(fileEntity, hotspot.getKey(), transaction, HOTSPOT_ENTITY_TYPE, "hotspots");
        XodusServerIssueStore.updateHotspotEntity(hotspotEntity, hotspot);
    }

    private static void updateHotspotEntity(Entity issueEntity, ServerHotspot hotspot) {
        issueEntity.setProperty(RULE_KEY_PROPERTY_NAME, (Comparable)((Object)hotspot.getRuleKey()));
        issueEntity.setBlobString(MESSAGE_BLOB_NAME, hotspot.getMessage());
        TextRange textRange = hotspot.getTextRange();
        issueEntity.setProperty(START_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLine()));
        issueEntity.setProperty(START_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLineOffset()));
        issueEntity.setProperty(END_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLine()));
        issueEntity.setProperty(END_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLineOffset()));
        issueEntity.setProperty(CREATION_DATE_PROPERTY_NAME, (Comparable)hotspot.getCreationDate());
        issueEntity.setProperty(REVIEW_STATUS_PROPERTY_NAME, (Comparable)((Object)hotspot.getStatus()));
        issueEntity.setProperty(VULNERABILITY_PROBABILITY_PROPERTY_NAME, (Comparable)((Object)hotspot.getVulnerabilityProbability().toString()));
        if (hotspot.getAssignee() != null) {
            issueEntity.setProperty(ASSIGNEE_PROPERTY_NAME, (Comparable)((Object)hotspot.getAssignee()));
        }
    }

    private static void deleteAllHotspotsOfFile(@NotNull StoreTransaction txn, Entity fileEntity) {
        XodusServerIssueStore.replaceAllHotspotsOfFile(List.of(), txn, fileEntity);
    }

    private static void deleteAllIssuesOfFile(@NotNull StoreTransaction txn, Entity fileEntity) {
        XodusServerIssueStore.replaceAllIssuesOfFile(List.of(), txn, fileEntity);
    }

    private static void timed(String msg, Runnable transaction) {
        Instant startTime = Instant.now();
        transaction.run();
        Duration duration = Duration.between(startTime, Instant.now());
        LOG.debug("{} | took {}ms", (Object)msg, (Object)duration.toMillis());
    }

    private static void replaceAllIssuesOfFile(List<ServerIssue> issues, @NotNull StoreTransaction txn, Entity fileEntity) {
        fileEntity.getLinks("issues").forEach(Entity::delete);
        fileEntity.deleteLinks("issues");
        issues.forEach(issue -> XodusServerIssueStore.updateOrCreateIssue(fileEntity, issue, txn));
    }

    @Override
    public void replaceAllTaintOfFile(String branchName, String serverFilePath, List<ServerTaintIssue> issues) {
        XodusServerIssueStore.timed("Wrote " + issues.size() + " taint issues in store", () -> this.entityStore.executeInTransaction(txn -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, serverFilePath, txn);
            fileEntity.getLinks("taintIssues").forEach(Entity::delete);
            fileEntity.deleteLinks("taintIssues");
            issues.forEach(issue -> XodusServerIssueStore.updateOrCreateTaintIssue(branch, fileEntity, issue, txn));
        }));
    }

    private static Entity getOrCreateBranch(String branchName, StoreTransaction txn) {
        return XodusServerIssueStore.findUnique(txn, BRANCH_ENTITY_TYPE, NAME_PROPERTY_NAME, branchName).orElseGet(() -> {
            Entity branch = txn.newEntity(BRANCH_ENTITY_TYPE);
            branch.setProperty(NAME_PROPERTY_NAME, (Comparable)((Object)branchName));
            return branch;
        });
    }

    private static Entity getOrCreateFile(Entity branchEntity, String filePath, StoreTransaction txn) {
        return XodusServerIssueStore.findUniqueAmong(branchEntity.getLinks(BRANCH_TO_FILES_LINK_NAME), PATH_PROPERTY_NAME, filePath).orElseGet(() -> {
            Entity file = txn.newEntity(FILE_ENTITY_TYPE);
            file.setProperty(PATH_PROPERTY_NAME, (Comparable)((Object)filePath));
            branchEntity.addLink(BRANCH_TO_FILES_LINK_NAME, file);
            return file;
        });
    }

    private static void updateOrCreateIssue(Entity fileEntity, ServerIssue issue, StoreTransaction transaction) {
        Entity issueEntity = XodusServerIssueStore.updateOrCreateIssueCommon(fileEntity, issue.getKey(), transaction, ISSUE_ENTITY_TYPE, "issues");
        XodusServerIssueStore.updateIssueEntity(issueEntity, issue);
    }

    private static void updateIssueEntity(Entity issueEntity, ServerIssue issue) {
        issueEntity.setProperty(RESOLVED_PROPERTY_NAME, (Comparable)Boolean.valueOf(issue.isResolved()));
        issueEntity.setProperty(RULE_KEY_PROPERTY_NAME, (Comparable)((Object)issue.getRuleKey()));
        issueEntity.setBlobString(MESSAGE_BLOB_NAME, issue.getMessage());
        issueEntity.setProperty(CREATION_DATE_PROPERTY_NAME, (Comparable)issue.getCreationDate());
        IssueSeverity userSeverity = issue.getUserSeverity();
        if (userSeverity != null) {
            issueEntity.setProperty(USER_SEVERITY_PROPERTY_NAME, (Comparable)((Object)userSeverity));
        }
        issueEntity.setProperty(TYPE_PROPERTY_NAME, (Comparable)((Object)issue.getType()));
        if (issue instanceof LineLevelServerIssue) {
            LineLevelServerIssue lineIssue = (LineLevelServerIssue)issue;
            issueEntity.setBlobString(LINE_HASH_PROPERTY_NAME, lineIssue.getLineHash());
            issueEntity.setProperty(START_LINE_PROPERTY_NAME, (Comparable)lineIssue.getLine());
        } else if (issue instanceof RangeLevelServerIssue) {
            RangeLevelServerIssue rangeIssue = (RangeLevelServerIssue)issue;
            TextRangeWithHash textRange = rangeIssue.getTextRange();
            issueEntity.setProperty(START_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLine()));
            issueEntity.setProperty(START_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLineOffset()));
            issueEntity.setProperty(END_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLine()));
            issueEntity.setProperty(END_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLineOffset()));
            issueEntity.setBlobString(RANGE_HASH_PROPERTY_NAME, textRange.getHash());
        }
    }

    private static void updateOrCreateTaintIssue(Entity branchEntity, Entity fileEntity, ServerTaintIssue issue, StoreTransaction transaction) {
        Entity issueEntity = XodusServerIssueStore.updateOrCreateIssueCommon(fileEntity, issue.getKey(), transaction, TAINT_ISSUE_ENTITY_TYPE, "taintIssues");
        XodusServerIssueStore.updateTaintIssueEntity(issue, issueEntity);
        branchEntity.addLink("taintIssues", issueEntity);
        issueEntity.setLink(TAINT_ISSUE_TO_BRANCH_LINK_NAME, branchEntity);
    }

    private static void updateTaintIssueEntity(ServerTaintIssue issue, Entity issueEntity) {
        issueEntity.setProperty(RESOLVED_PROPERTY_NAME, (Comparable)Boolean.valueOf(issue.isResolved()));
        issueEntity.setProperty(RULE_KEY_PROPERTY_NAME, (Comparable)((Object)issue.getRuleKey()));
        issueEntity.setBlobString(MESSAGE_BLOB_NAME, issue.getMessage());
        issueEntity.setProperty(CREATION_DATE_PROPERTY_NAME, (Comparable)issue.getCreationDate());
        issueEntity.setProperty(SEVERITY_PROPERTY_NAME, (Comparable)((Object)issue.getSeverity()));
        issueEntity.setProperty(TYPE_PROPERTY_NAME, (Comparable)((Object)issue.getType()));
        TextRangeWithHash textRange = issue.getTextRange();
        if (textRange != null) {
            issueEntity.setProperty(START_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLine()));
            issueEntity.setProperty(START_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLineOffset()));
            issueEntity.setProperty(END_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLine()));
            issueEntity.setProperty(END_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLineOffset()));
            issueEntity.setBlobString(RANGE_HASH_PROPERTY_NAME, textRange.getHash());
        }
        issueEntity.setBlob(FLOWS_BLOB_NAME, XodusServerIssueStore.toProtoFlow(issue.getFlows()));
        String ruleDescriptionContextKey = issue.getRuleDescriptionContextKey();
        if (ruleDescriptionContextKey != null) {
            issueEntity.setProperty(RULE_DESCRIPTION_CONTEXT_KEY_PROPERTY_NAME, (Comparable)((Object)ruleDescriptionContextKey));
        }
        issue.getCleanCodeAttribute().ifPresent(attribute -> issueEntity.setProperty(CLEAN_CODE_ATTRIBUTE_PROPERTY_NAME, (Comparable)((Object)attribute.name())));
        issueEntity.setBlob(IMPACTS_BLOB_NAME, XodusServerIssueStore.toProtoImpact(issue.getImpacts()));
    }

    public static InputStream toProtoFlow(List<ServerTaintIssue.Flow> flows) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ProtobufUtil.writeMessages(buffer, flows.stream().map(XodusServerIssueStore::toProtoFlow).collect(Collectors.toList()));
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    public static InputStream toProtoImpact(Map<SoftwareQuality, ImpactSeverity> impacts) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ProtobufUtil.writeMessages(buffer, impacts.entrySet().stream().map(XodusServerIssueStore::toProtoImpact).collect(Collectors.toList()));
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    private static Entity updateOrCreateIssueCommon(Entity fileEntity, String issueKey, StoreTransaction transaction, String entityType, String fileToIssueLink) {
        Entity issueEntity = XodusServerIssueStore.findUnique(transaction, entityType, KEY_PROPERTY_NAME, issueKey).orElseGet(() -> transaction.newEntity(entityType));
        Entity oldFileEntity = issueEntity.getLink(ISSUE_TO_FILE_LINK_NAME);
        if (oldFileEntity != null && !fileEntity.equals(oldFileEntity)) {
            oldFileEntity.deleteLink(fileToIssueLink, issueEntity);
        }
        issueEntity.setLink(ISSUE_TO_FILE_LINK_NAME, fileEntity);
        fileEntity.addLink(fileToIssueLink, issueEntity);
        issueEntity.setProperty(KEY_PROPERTY_NAME, (Comparable)((Object)issueKey));
        return issueEntity;
    }

    private static Optional<Entity> findUnique(StoreTransaction transaction, String entityType, String propertyName, String caseSensitivePropertyValue) {
        EntityIterable entities = transaction.find(entityType, propertyName, (Comparable)((Object)caseSensitivePropertyValue));
        return XodusServerIssueStore.findUniqueAmong(entities, propertyName, caseSensitivePropertyValue);
    }

    private static Optional<Entity> findUniqueAmong(EntityIterable iterable, String propertyName, String caseSensitivePropertyValue) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(e -> caseSensitivePropertyValue.equals(e.getProperty(propertyName))).findFirst();
    }

    private static void remove(String issueKey, @NotNull StoreTransaction txn) {
        XodusServerIssueStore.findUnique(txn, ISSUE_ENTITY_TYPE, KEY_PROPERTY_NAME, issueKey).ifPresent(issueEntity -> {
            Entity fileEntity = issueEntity.getLink(ISSUE_TO_FILE_LINK_NAME);
            if (fileEntity != null) {
                fileEntity.deleteLink("issues", issueEntity);
            }
            issueEntity.deleteLinks(ISSUE_TO_FILE_LINK_NAME);
            issueEntity.delete();
        });
    }

    private static void removeTaint(String issueKey, @NotNull StoreTransaction txn) {
        XodusServerIssueStore.findUnique(txn, TAINT_ISSUE_ENTITY_TYPE, KEY_PROPERTY_NAME, issueKey).ifPresent(issueEntity -> {
            Entity fileEntity = issueEntity.getLink(ISSUE_TO_FILE_LINK_NAME);
            if (fileEntity != null) {
                fileEntity.deleteLink("taintIssues", issueEntity);
            }
            issueEntity.deleteLinks(ISSUE_TO_FILE_LINK_NAME);
            Entity branchEntity = issueEntity.getLink(TAINT_ISSUE_TO_BRANCH_LINK_NAME);
            if (branchEntity != null) {
                branchEntity.deleteLink("taintIssues", issueEntity);
            }
            issueEntity.deleteLinks(TAINT_ISSUE_TO_BRANCH_LINK_NAME);
            issueEntity.delete();
        });
    }

    private static void removeHotspot(String hotspotKey, @NotNull StoreTransaction txn) {
        XodusServerIssueStore.findUnique(txn, HOTSPOT_ENTITY_TYPE, KEY_PROPERTY_NAME, hotspotKey).ifPresent(hotspotEntity -> {
            Entity fileEntity = hotspotEntity.getLink(ISSUE_TO_FILE_LINK_NAME);
            if (fileEntity != null) {
                fileEntity.deleteLink("hotspots", hotspotEntity);
            }
            hotspotEntity.deleteLinks(ISSUE_TO_FILE_LINK_NAME);
            hotspotEntity.delete();
        });
    }

    @Override
    public boolean updateIssue(String issueKey, Consumer<ServerIssue> issueUpdater) {
        return (Boolean)this.entityStore.computeInTransaction(txn -> {
            Optional<Entity> optionalEntity = XodusServerIssueStore.findUnique(txn, ISSUE_ENTITY_TYPE, KEY_PROPERTY_NAME, issueKey);
            if (optionalEntity.isPresent()) {
                Entity issueEntity = optionalEntity.get();
                ServerIssue currentIssue = XodusServerIssueStore.adapt(issueEntity);
                issueUpdater.accept(currentIssue);
                XodusServerIssueStore.updateIssueEntity(issueEntity, currentIssue);
                return true;
            }
            return false;
        });
    }

    @Override
    public ServerIssue getIssue(String issueKey) {
        return (ServerIssue)this.entityStore.computeInTransaction(txn -> {
            Optional<Entity> optionalEntity = XodusServerIssueStore.findUnique(txn, ISSUE_ENTITY_TYPE, KEY_PROPERTY_NAME, issueKey);
            if (optionalEntity.isPresent()) {
                Entity issueEntity = optionalEntity.get();
                return XodusServerIssueStore.adapt(issueEntity);
            }
            return null;
        });
    }

    @Override
    public ServerHotspot getHotspot(String hotspotKey) {
        return (ServerHotspot)this.entityStore.computeInTransaction(txn -> {
            Optional<Entity> optionalEntity = XodusServerIssueStore.findUnique(txn, HOTSPOT_ENTITY_TYPE, KEY_PROPERTY_NAME, hotspotKey);
            if (optionalEntity.isPresent()) {
                Entity hotspotEntity = optionalEntity.get();
                return XodusServerIssueStore.adaptHotspot(hotspotEntity);
            }
            return null;
        });
    }

    @Override
    public Optional<ServerFinding> updateIssueResolutionStatus(String issueKey, boolean isTaintIssue, boolean isResolved) {
        String entityIssueType = isTaintIssue ? TAINT_ISSUE_ENTITY_TYPE : ISSUE_ENTITY_TYPE;
        return (Optional)this.entityStore.computeInTransaction(txn -> {
            Optional<Entity> optionalEntity = XodusServerIssueStore.findUnique(txn, entityIssueType, KEY_PROPERTY_NAME, issueKey);
            if (optionalEntity.isPresent()) {
                Entity issueEntity = optionalEntity.get();
                issueEntity.setProperty(RESOLVED_PROPERTY_NAME, (Comparable)Boolean.valueOf(isResolved));
                return Optional.of(isTaintIssue ? XodusServerIssueStore.adaptTaint(issueEntity) : XodusServerIssueStore.adapt(issueEntity));
            }
            return Optional.empty();
        });
    }

    @Override
    public boolean containsIssue(String issueKey, boolean isTaintIssue) {
        String entityIssueType = isTaintIssue ? TAINT_ISSUE_ENTITY_TYPE : ISSUE_ENTITY_TYPE;
        return (Boolean)this.entityStore.computeInTransaction(txn -> {
            Optional<Entity> optionalEntity = XodusServerIssueStore.findUnique(txn, entityIssueType, KEY_PROPERTY_NAME, issueKey);
            return optionalEntity.isPresent();
        });
    }

    @Override
    public void updateTaintIssue(String issueKey, Consumer<ServerTaintIssue> taintIssueUpdater) {
        this.entityStore.executeInTransaction(txn -> XodusServerIssueStore.findUnique(txn, TAINT_ISSUE_ENTITY_TYPE, KEY_PROPERTY_NAME, issueKey).ifPresent(issueEntity -> {
            ServerTaintIssue currentIssue = XodusServerIssueStore.adaptTaint(issueEntity);
            taintIssueUpdater.accept(currentIssue);
            XodusServerIssueStore.updateTaintIssueEntity(currentIssue, issueEntity);
        }));
    }

    @Override
    public void insert(String branchName, ServerTaintIssue taintIssue) {
        this.entityStore.executeInTransaction(txn -> XodusServerIssueStore.findUnique(txn, TAINT_ISSUE_ENTITY_TYPE, KEY_PROPERTY_NAME, taintIssue.getKey()).ifPresentOrElse(issueEntity -> LOG.error("Trying to store a taint vulnerability that already exists"), () -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, taintIssue.getFilePath(), txn);
            XodusServerIssueStore.updateOrCreateTaintIssue(branch, fileEntity, taintIssue, txn);
        }));
    }

    @Override
    public void insert(String branchName, ServerHotspot hotspot) {
        this.entityStore.executeInTransaction(txn -> XodusServerIssueStore.findUnique(txn, HOTSPOT_ENTITY_TYPE, KEY_PROPERTY_NAME, hotspot.getKey()).ifPresentOrElse(hotspotEntity -> LOG.error("Trying to store a hotspot that already exists"), () -> {
            Entity branch = XodusServerIssueStore.getOrCreateBranch(branchName, txn);
            Entity fileEntity = XodusServerIssueStore.getOrCreateFile(branch, hotspot.getFilePath(), txn);
            XodusServerIssueStore.updateOrCreateHotspot(fileEntity, hotspot, txn);
        }));
    }

    @Override
    public void deleteTaintIssue(String issueKeyToDelete) {
        this.entityStore.executeInTransaction(txn -> XodusServerIssueStore.removeTaint(issueKeyToDelete, txn));
    }

    @Override
    public void deleteHotspot(String hotspotKey) {
        this.entityStore.executeInTransaction(txn -> XodusServerIssueStore.findUnique(txn, HOTSPOT_ENTITY_TYPE, KEY_PROPERTY_NAME, hotspotKey).ifPresent(hotspotEntity -> {
            Entity fileEntity = hotspotEntity.getLink(ISSUE_TO_FILE_LINK_NAME);
            if (fileEntity != null) {
                fileEntity.deleteLink("hotspots", hotspotEntity);
            }
            hotspotEntity.deleteLinks(ISSUE_TO_FILE_LINK_NAME);
            hotspotEntity.delete();
        }));
    }

    @Override
    public void close() {
        this.backup();
        this.entityStore.close();
        FileUtils.deleteQuietly(this.xodusDbDir.toFile());
    }

    @Override
    public void updateHotspot(String hotspotKey, Consumer<ServerHotspot> hotspotUpdater) {
        this.entityStore.executeInTransaction(txn -> XodusServerIssueStore.findUnique(txn, HOTSPOT_ENTITY_TYPE, KEY_PROPERTY_NAME, hotspotKey).ifPresent(hotspotEntity -> {
            ServerHotspot currentHotspot = XodusServerIssueStore.adaptHotspot(hotspotEntity);
            hotspotUpdater.accept(currentHotspot);
            XodusServerIssueStore.updateHotspotEntity(hotspotEntity, currentHotspot);
        }));
    }

    public void backup() {
        LOG.debug("Creating backup of server issue database in {}", (Object)this.backupFile);
        try {
            File backupTmp = CompressBackupUtil.backup((Backupable)this.entityStore, (File)this.backupFile.getParent().toFile(), (String)"backup", (boolean)false);
            Files.move(backupTmp.toPath(), this.backupFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Exception e) {
            LOG.error("Unable to backup server issue database", e);
        }
    }

    private static ServerTaintIssue.Flow toJavaFlow(Sonarlint.Flow flowProto) {
        return new ServerTaintIssue.Flow(flowProto.getLocationList().stream().map(XodusServerIssueStore::toJavaLocation).collect(Collectors.toList()));
    }

    private static Map.Entry<SoftwareQuality, ImpactSeverity> toJavaImpact(Sonarlint.Impact impactProto) {
        return Map.entry(SoftwareQuality.valueOf(impactProto.getSoftwareQuality()), ImpactSeverity.valueOf(impactProto.getSeverity()));
    }

    private static ServerTaintIssue.ServerIssueLocation toJavaLocation(Sonarlint.Location locationProto) {
        return new ServerTaintIssue.ServerIssueLocation(locationProto.hasFilePath() ? locationProto.getFilePath() : null, locationProto.hasTextRange() ? XodusServerIssueStore.toTextRangeJava(locationProto.getTextRange()) : null, locationProto.getMessage());
    }

    private static TextRangeWithHash toTextRangeJava(Sonarlint.TextRange textRange) {
        return new TextRangeWithHash(textRange.getStartLine(), textRange.getStartLineOffset(), textRange.getEndLine(), textRange.getEndLineOffset(), textRange.getHash());
    }

    private static Sonarlint.Flow toProtoFlow(ServerTaintIssue.Flow javaFlow) {
        Sonarlint.Flow.Builder flowBuilder = Sonarlint.Flow.newBuilder();
        javaFlow.locations().forEach(l -> flowBuilder.addLocation(XodusServerIssueStore.toProtoLocation(l)));
        return flowBuilder.build();
    }

    private static Sonarlint.Impact toProtoImpact(Map.Entry<SoftwareQuality, ImpactSeverity> impact) {
        return Sonarlint.Impact.newBuilder().setSoftwareQuality(impact.getKey().name()).setSeverity(impact.getValue().name()).build();
    }

    private static Sonarlint.Location toProtoLocation(ServerTaintIssue.ServerIssueLocation l) {
        Sonarlint.Location.Builder location = Sonarlint.Location.newBuilder();
        String filePath = l.getFilePath();
        if (filePath != null) {
            location.setFilePath(filePath);
        }
        location.setMessage(l.getMessage());
        TextRangeWithHash textRange = l.getTextRange();
        if (textRange != null) {
            location.setTextRange(Sonarlint.TextRange.newBuilder().setStartLine(textRange.getStartLine()).setStartLineOffset(textRange.getStartLineOffset()).setEndLine(textRange.getEndLine()).setEndLineOffset(textRange.getEndLineOffset()).setHash(textRange.getHash()));
        }
        return location.build();
    }

    static void checkCurrentSchemaVersion(StoreTransaction txn) {
        int currentSchemaVersion = XodusServerIssueStore.getCurrentSchemaVersion(txn);
        if (currentSchemaVersion < 1) {
            txn.getAll(BRANCH_ENTITY_TYPE).forEach(b -> b.setProperty(LAST_TAINT_SYNC_PROPERTY_NAME, (Comparable)Instant.EPOCH));
            txn.getAll(SCHEMA_ENTITY_TYPE).forEach(Entity::delete);
            Entity newSchema = txn.newEntity(SCHEMA_ENTITY_TYPE);
            newSchema.setProperty(VERSION_PROPERTY_NAME, (Comparable)Integer.valueOf(1));
            txn.saveEntity(newSchema);
            txn.flush();
        }
    }

    static int getCurrentSchemaVersion(StoreTransaction txn) {
        EntityIterable schemaEntities = txn.getAll(SCHEMA_ENTITY_TYPE);
        long schemaEntitiesCount = schemaEntities.size();
        if (schemaEntitiesCount == 1L) {
            Entity schemaEntity = schemaEntities.getFirst();
            Comparable schemaVersion = schemaEntity.getProperty(VERSION_PROPERTY_NAME);
            if (schemaVersion == null) {
                return 0;
            }
            return (Integer)schemaVersion;
        }
        return 0;
    }

    int getCurrentSchemaVersion() {
        return (Integer)this.entityStore.computeInTransaction(XodusServerIssueStore::getCurrentSchemaVersion);
    }
}

