/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class TelemetryAnalyzerPerformance {
    private static final TreeMap<Integer, String> INTERVALS = new TreeMap();
    private int analysisCount;
    private Map<String, Integer> frequencies = new LinkedHashMap<String, Integer>();

    public TelemetryAnalyzerPerformance() {
        INTERVALS.forEach((k, v) -> this.frequencies.put((String)v, 0));
    }

    public void registerAnalysis(int analysisTimeMs) {
        Map.Entry<Integer, String> entry = INTERVALS.higherEntry(analysisTimeMs);
        if (entry != null) {
            this.frequencies.compute(entry.getValue(), (k, v) -> v != null ? v + 1 : 1);
            ++this.analysisCount;
        }
    }

    public Map<String, Integer> frequencies() {
        return this.frequencies;
    }

    public int analysisCount() {
        return this.analysisCount;
    }

    static {
        INTERVALS.put(300, "0-300");
        INTERVALS.put(500, "300-500");
        INTERVALS.put(1000, "500-1000");
        INTERVALS.put(2000, "1000-2000");
        INTERVALS.put(4000, "2000-4000");
        INTERVALS.put(Integer.MAX_VALUE, "4000+");
    }
}

