/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.clientapi.backend.telemetry.GetStatusResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.telemetry.TelemetryService;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.telemetry.TelemetryLocalStorage;
import org.sonarsource.sonarlint.core.telemetry.TelemetryLocalStorageManager;
import org.sonarsource.sonarlint.core.telemetry.TelemetryPathManager;

public class TelemetryServiceImpl
implements TelemetryService {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    static final String DISABLE_PROPERTY_KEY = "sonarlint.telemetry.disabled";
    @CheckForNull
    private final TelemetryLocalStorageManager telemetryLocalStorageManager;

    public TelemetryServiceImpl(String productKey, Path sonarlintUserHome, boolean focusOnNewCode) {
        if (TelemetryServiceImpl.isDisabledBySystemProperty()) {
            LOG.info("Telemetry disabled by system property");
            this.telemetryLocalStorageManager = null;
            return;
        }
        this.telemetryLocalStorageManager = new TelemetryLocalStorageManager(TelemetryPathManager.getPath(sonarlintUserHome, productKey));
        this.telemetryLocalStorageManager.tryUpdateAtomically(storage -> storage.setInitialNewCodeFocus(focusOnNewCode));
    }

    private static boolean isDisabledBySystemProperty() {
        return "true".equals(System.getProperty(DISABLE_PROPERTY_KEY));
    }

    private TelemetryLocalStorageManager getTelemetryLocalStorageManager() {
        if (this.telemetryLocalStorageManager == null) {
            throw new IllegalStateException("Telemetry service has not been initialized");
        }
        return this.telemetryLocalStorageManager;
    }

    @Override
    public CompletableFuture<GetStatusResponse> getStatus() {
        return CompletableFuture.completedFuture(new GetStatusResponse(this.isEnabled()));
    }

    private boolean isEnabled() {
        return !TelemetryServiceImpl.isDisabledBySystemProperty() && this.telemetryLocalStorageManager != null && this.telemetryLocalStorageManager.tryRead().enabled();
    }

    public void hotspotOpenedInBrowser() {
        if (this.isEnabled()) {
            this.getTelemetryLocalStorageManager().tryUpdateAtomically(TelemetryLocalStorage::incrementOpenHotspotInBrowserCount);
        }
    }

    public void showHotspotRequestReceived() {
        if (this.isEnabled()) {
            this.getTelemetryLocalStorageManager().tryUpdateAtomically(TelemetryLocalStorage::incrementShowHotspotRequestCount);
        }
    }

    public void showIssueRequestReceived() {
        if (this.isEnabled()) {
            this.getTelemetryLocalStorageManager().tryUpdateAtomically(TelemetryLocalStorage::incrementShowIssueRequestCount);
        }
    }

    public void smartNotificationsReceived(String eventType) {
        if (this.isEnabled()) {
            this.getTelemetryLocalStorageManager().tryUpdateAtomically(s -> s.incrementDevNotificationsCount(eventType));
        }
    }

    public void hotspotStatusChanged() {
        if (this.isEnabled()) {
            this.getTelemetryLocalStorageManager().tryUpdateAtomically(TelemetryLocalStorage::incrementHotspotStatusChangedCount);
        }
    }

    public void issueStatusChanged(String ruleKey) {
        if (this.isEnabled()) {
            this.getTelemetryLocalStorageManager().tryUpdateAtomically(telemetryLocalStorage -> telemetryLocalStorage.addIssueStatusChanged(ruleKey));
        }
    }

    public void newCodeFocusChanged() {
        if (this.isEnabled()) {
            this.getTelemetryLocalStorageManager().tryUpdateAtomically(storage -> storage.incrementNewCodeFocusChange());
        }
    }
}

