/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service.client;

import com.teamscale.commons.service.client.ServerDetails;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.version.Version;

public class ServiceClientUris {
    public static final String RECURSIVE_PARAMETER = "recursive";
    public static final String BASELINE_PARAMETER = "baseline";
    public static final String INCLUDE_CHANGED_CODE_FINDINGS_PARAMETER = "include-changed-code-findings";
    public static final String ONLY_CHANGED_CODE_FINDINGS_PARAMETER = "only-changed-code-findings";
    public static final String PRINCIPAL_METRIC_INDEX_PARAMETER = "principal-metric-index";
    public static final String METRIC_INDEXES_PARAMETER = "metric-indexes";
    public static final String BOUNDARY_PARAMETER = "boundaries";
    public static final String TIMESTAMP_PARAMETER_NAME = "t";
    public static final String MERGE_REQUEST_ID_PARAMETER_NAME = "merge-request";

    private ServiceClientUris() {
    }

    public static String getGlobal(String serviceName, ServerDetails serverDetails, Pair<?, ?> ... options) {
        return ServiceClientUris.getGlobal(serviceName, serverDetails, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getGlobal(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, Pair<?, ?> ... options) {
        return ServiceClientUris.getGlobal(serviceName, serverDetails, teamscaleVersion, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getGlobal(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, ListMap<String, String> options) {
        return StringUtils.ensureEndsWith((String)serverDetails.getUrl(), (String)"/") + "api/v" + String.valueOf(teamscaleVersion) + "/" + serviceName + ServiceClientUris.createOptionString(options);
    }

    public static String getGlobalResource(String resourcePath, ServerDetails serverDetails) {
        return StringUtils.ensureEndsWith((String)serverDetails.getUrl(), (String)"/") + resourcePath;
    }

    public static String getGlobal(String serviceName, ServerDetails serverDetails, ListMap<String, String> options) {
        return StringUtils.ensureEndsWith((String)serverDetails.getUrl(), (String)"/") + "api/" + serviceName + ServiceClientUris.createOptionString(options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, PublicProjectId projectId, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, PublicProjectId projectId, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, PublicProjectId projectId, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, "", options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, PublicProjectId projectId, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, "", options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, PublicProjectId projectId, UniformPath uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, PublicProjectId projectId, UniformPath uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, PublicProjectId projectId, String uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, uniformPath, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, PublicProjectId projectId, String uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, uniformPath, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, PublicProjectId projectId, UniformPath uniformPath, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, PublicProjectId projectId, UniformPath uniformPath, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, PublicProjectId projectId, String uniformPath, ListMap<String, String> options) {
        return StringUtils.ensureEndsWith((String)serverDetails.getUrl(), (String)"/") + "api/projects/" + String.valueOf(projectId) + "/" + serviceName + "/" + UrlUtils.encodePathSegment((String)uniformPath) + ServiceClientUris.createOptionString(options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, PublicProjectId projectId, String uniformPath, ListMap<String, String> options) {
        return StringUtils.ensureEndsWith((String)serverDetails.getUrl(), (String)"/") + "api/v" + String.valueOf(teamscaleVersion) + "/projects/" + String.valueOf(projectId) + "/" + serviceName + "/" + UrlUtils.encodePathSegment((String)uniformPath) + ServiceClientUris.createOptionString(options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, String projectId, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, String projectId, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, String projectId, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, "", options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, String projectId, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, "", options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, String projectId, UniformPath uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, String projectId, UniformPath uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, String projectId, String uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, uniformPath, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, String projectId, String uniformPath, Pair<?, ?> ... options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, uniformPath, (ListMap<String, String>)ListMap.fromNonEmptyPairs(options));
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, String projectId, UniformPath uniformPath, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, String projectId, UniformPath uniformPath, ListMap<String, String> options) {
        return ServiceClientUris.getProject(serviceName, serverDetails, teamscaleVersion, projectId, uniformPath.toString(), options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, String projectId, String uniformPath, ListMap<String, String> options) {
        return StringUtils.ensureEndsWith((String)serverDetails.getUrl(), (String)"/") + "api/projects/" + UrlUtils.encodePathSegment((String)projectId) + "/" + serviceName + "/" + UrlUtils.encodePathSegment((String)uniformPath) + ServiceClientUris.createOptionString(options);
    }

    public static String getProject(String serviceName, ServerDetails serverDetails, Version teamscaleVersion, String projectId, String uniformPath, ListMap<String, String> options) {
        return StringUtils.ensureEndsWith((String)serverDetails.getUrl(), (String)"/") + "api/v" + String.valueOf(teamscaleVersion) + "/projects/" + UrlUtils.encodePathSegment((String)projectId) + "/" + serviceName + "/" + UrlUtils.encodePathSegment((String)uniformPath) + ServiceClientUris.createOptionString(options);
    }

    public static String createOptionString(String ... parametersAndValues) {
        return ServiceClientUris.createOptionString((ListMap<String, String>)ListMap.of((String[])parametersAndValues));
    }

    private static String createOptionString(ListMap<String, String> options) {
        StringBuilder sb = new StringBuilder();
        if (options != null) {
            String separator = "?";
            for (String option : options.getKeys()) {
                List values = (List)options.getCollection((Object)option);
                for (String value : values) {
                    value = UrlUtils.encodeQueryParameter((String)value);
                    sb.append(separator).append(option).append('=').append(value);
                    separator = "&";
                }
            }
        }
        return sb.toString();
    }

    public static Pair<String, String> createCommitDescriptorOption(CommitDescriptor commitDescriptor) {
        if (commitDescriptor == null) {
            return null;
        }
        return Pair.createPair((Object)TIMESTAMP_PARAMETER_NAME, (Object)commitDescriptor.toServiceCallFormat());
    }
}

