/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.utils;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ObjectPool<T> {
    private final WeakHashMap<T, WeakReference<T>>[] objectPools;

    public ObjectPool() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public ObjectPool(int concurrency) {
        Preconditions.checkArgument((concurrency > 0 ? 1 : 0) != 0, (String)"Concurrency must be positive. Given: %s", (int)concurrency);
        this.objectPools = new WeakHashMap[concurrency];
        Arrays.setAll(this.objectPools, i -> new WeakHashMap(10000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T intern(T object) {
        WeakHashMap<T, WeakReference<T>> objectPool;
        WeakHashMap<T, WeakReference<T>> weakHashMap = objectPool = this.poolFor(object);
        synchronized (weakHashMap) {
            Object value;
            WeakReference<T> cached = objectPool.get(object);
            if (cached != null && (value = cached.get()) != null) {
                return value;
            }
            objectPool.put(object, new WeakReference<T>(object));
            return object;
        }
    }

    private WeakHashMap<T, WeakReference<T>> poolFor(Object key) {
        int hash = ObjectPool.hash(key);
        int index = Math.floorMod(hash, this.objectPools.length);
        return this.objectPools[index];
    }

    private static int hash(Object key) {
        int hashCode = key.hashCode();
        return hashCode ^ hashCode >>> 16;
    }
}

