/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings.location;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ILineAdjuster;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class LocationAdjuster
implements ILineAdjuster {
    private static final double LOSS_FACTOR = 2.0;
    private static final int MAX_DIFF_SIZE = 5000;
    private final Supplier<List<AdjusterToken>> lazyOriginalTokens;
    private final Supplier<List<AdjusterToken>> lazyMappedAdjustedTokens;
    private final LineOffsetConverter originalLineOffsetConverter;
    private final LineOffsetConverter adjustedLineOffsetConverter;
    private final String adjustedUniformPath;

    public LocationAdjuster(@Nullable String originalText, String adjustedText, String adjustedUniformPath) {
        this.adjustedUniformPath = adjustedUniformPath;
        if (originalText != null) {
            this.originalLineOffsetConverter = new LineOffsetConverter(originalText);
            this.lazyOriginalTokens = Suppliers.memoize(() -> LocationAdjuster.toTokens(originalText));
        } else {
            this.originalLineOffsetConverter = new LineOffsetConverter(adjustedText);
            this.lazyOriginalTokens = Suppliers.memoize(() -> LocationAdjuster.toTokens(adjustedText));
        }
        this.adjustedLineOffsetConverter = new LineOffsetConverter(adjustedText);
        this.lazyMappedAdjustedTokens = Suppliers.memoize(() -> LocationAdjuster.calculateMappedAdjustedTokens(adjustedText, this.lazyOriginalTokens.get()));
    }

    public LocationAdjuster(String originalText, String adjustedText) {
        this(originalText, adjustedText, null);
    }

    private static List<AdjusterToken> calculateMappedAdjustedTokens(String adjustedText, List<AdjusterToken> originalTokens) {
        List<AdjusterToken> adjustedTokens = LocationAdjuster.toTokens(adjustedText);
        Diff.Delta delta = Diff.computeDelta(originalTokens, adjustedTokens, (int)5000);
        if (delta.getSize() >= 5000) {
            return null;
        }
        return LocationAdjuster.calculateMappedAdjustedTokensFromDelta((Diff.Delta<AdjusterToken>)delta, originalTokens, adjustedTokens);
    }

    private static List<AdjusterToken> calculateMappedAdjustedTokensFromDelta(Diff.Delta<AdjusterToken> delta, List<AdjusterToken> originalTokens, List<AdjusterToken> adjustedTokens) {
        ArrayList<Object> mappedAdjustedTokens = new ArrayList<Object>(Collections.nCopies(originalTokens.size(), null));
        int originalIndex = 0;
        int adjustedIndex = 0;
        for (int i = 0; i < delta.getSize(); ++i) {
            int position = delta.getPosition(i);
            if (position > 0) {
                --position;
                while (adjustedIndex < position) {
                    mappedAdjustedTokens.set(originalIndex++, adjustedTokens.get(adjustedIndex++));
                }
                ++adjustedIndex;
                continue;
            }
            position = -position - 1;
            while (originalIndex < position) {
                mappedAdjustedTokens.set(originalIndex++, adjustedTokens.get(adjustedIndex++));
            }
            ++originalIndex;
        }
        while (originalIndex < originalTokens.size()) {
            mappedAdjustedTokens.set(originalIndex++, adjustedTokens.get(adjustedIndex++));
        }
        return mappedAdjustedTokens;
    }

    @VisibleForTesting
    static List<AdjusterToken> toTokens(String s) {
        ArrayList<AdjusterToken> tokens = new ArrayList<AdjusterToken>();
        int lastWordSeparator = -1;
        for (int i = 0; i < s.length(); ++i) {
            char currentCharacter = s.charAt(i);
            if (Character.isJavaIdentifierPart(currentCharacter)) continue;
            if (lastWordSeparator != i - 1) {
                tokens.add(new AdjusterToken(s.substring(lastWordSeparator + 1, i), lastWordSeparator + 1));
            }
            lastWordSeparator = i;
            if (Character.isWhitespace(currentCharacter)) continue;
            tokens.add(new AdjusterToken(s.substring(i, i + 1), i));
        }
        if (lastWordSeparator <= s.length() - 2) {
            tokens.add(new AdjusterToken(s.substring(lastWordSeparator + 1), lastWordSeparator + 1));
        }
        return tokens;
    }

    public @Nullable Region getAdjustedRegion(int originalStartOffset, int originalEndOffset) {
        List<AdjusterToken> mappedAdjustedTokens = this.lazyMappedAdjustedTokens.get();
        if (mappedAdjustedTokens == null) {
            return null;
        }
        Region originalIndexRegion = this.findOriginalIndexRegion(originalStartOffset, originalEndOffset);
        if (originalIndexRegion.isEmpty()) {
            return null;
        }
        int numOriginalTokens = originalIndexRegion.getLength();
        int numAdjustedTokens = 0;
        AdjusterToken firstAdjustedToken = null;
        AdjusterToken lastAdjustedToken = null;
        for (int i = originalIndexRegion.getStart(); i <= originalIndexRegion.getEnd(); ++i) {
            AdjusterToken adjustedToken = mappedAdjustedTokens.get(i);
            if (adjustedToken == null) continue;
            ++numAdjustedTokens;
            if (firstAdjustedToken == null) {
                firstAdjustedToken = adjustedToken;
            }
            lastAdjustedToken = adjustedToken;
        }
        if (firstAdjustedToken == null || lastAdjustedToken == null || 2.0 * (double)numAdjustedTokens < (double)numOriginalTokens) {
            return null;
        }
        return new Region(firstAdjustedToken.startOffset, lastAdjustedToken.endOffset);
    }

    private Region findOriginalIndexRegion(int originalStartOffset, int originalEndOffset) {
        int originalEndTokenIndex;
        AdjusterToken searchToken;
        List<AdjusterToken> originalTokens = this.lazyOriginalTokens.get();
        int originalStartTokenIndex = Collections.binarySearch(originalTokens, searchToken = new AdjusterToken(null, originalStartOffset, originalEndOffset), AdjusterToken.COMPARE_BY_START_OFFSET);
        if (originalStartTokenIndex < 0) {
            originalStartTokenIndex = -originalStartTokenIndex - 1;
        }
        if ((originalEndTokenIndex = Collections.binarySearch(originalTokens, searchToken, AdjusterToken.COMPARE_BY_END_OFFSET)) < 0) {
            originalEndTokenIndex = -originalEndTokenIndex - 2;
        }
        if (originalEndTokenIndex + 1 < originalTokens.size() && originalTokens.get((int)(originalEndTokenIndex + 1)).startOffset < originalEndOffset) {
            ++originalEndTokenIndex;
        }
        return new Region(originalStartTokenIndex, originalEndTokenIndex);
    }

    @Override
    public ElementLocation adjustLocation(ElementLocation location) {
        if (location instanceof TextRegionLocation) {
            return this.adjustLocation((TextRegionLocation)location);
        }
        if (this.adjustedUniformPath == null) {
            return location;
        }
        if (location instanceof QualifiedNameLocation) {
            return new QualifiedNameLocation(((QualifiedNameLocation)location).getQualifiedName(), this.adjustedUniformPath);
        }
        return new ElementLocation(this.adjustedUniformPath);
    }

    public TextRegionLocation adjustLocation(TextRegionLocation location) {
        Region adjustedOffsets;
        int startOffset = location.getRawStartOffset();
        int endOffset = location.getRawEndOffset();
        if (startOffset < 0) {
            int startLine = location.getRawStartLine();
            if (!this.originalLineOffsetConverter.isValidLine(startLine)) {
                return null;
            }
            startOffset = this.originalLineOffsetConverter.getOffset(startLine);
        }
        if (endOffset < 0) {
            int endLine = location.getRawEndLine() + 1;
            if (!this.originalLineOffsetConverter.isValidLine(endLine)) {
                return null;
            }
            endOffset = this.originalLineOffsetConverter.getOffset(endLine) - 1;
        }
        if ((adjustedOffsets = this.getAdjustedRegion(startOffset, endOffset)) == null || adjustedOffsets.isEmpty()) {
            return null;
        }
        String uniformPath = location.getUniformPath();
        if (this.adjustedUniformPath != null) {
            uniformPath = this.adjustedUniformPath;
        }
        int newStartOffset = adjustedOffsets.getStart();
        int newEndOffset = adjustedOffsets.getEnd();
        return new TextRegionLocation(uniformPath, newStartOffset, newEndOffset, this.adjustedLineOffsetConverter.getLine(newStartOffset), this.adjustedLineOffsetConverter.getLine(newEndOffset));
    }

    @Override
    public LineBasedRegion adjustLine(int line, Set<Integer> invalidLines) {
        int originalEndOffset;
        if (!this.originalLineOffsetConverter.isValidLine(line) || !this.originalLineOffsetConverter.isValidLine(line + 1)) {
            invalidLines.add(line);
            return null;
        }
        int originalStartOffset = this.originalLineOffsetConverter.getOffset(line);
        Region adjustedOffsets = this.getAdjustedRegion(originalStartOffset, originalEndOffset = this.originalLineOffsetConverter.getOffset(line + 1) - 1);
        if (adjustedOffsets == null) {
            return null;
        }
        int adjustedStartLine = this.adjustedLineOffsetConverter.getLine(adjustedOffsets.getStart());
        int adjustedEndLine = this.adjustedLineOffsetConverter.getLine(adjustedOffsets.getEnd());
        return new LineBasedRegion(adjustedStartLine, adjustedEndLine);
    }

    @Override
    public int getOriginalLineCount() {
        return this.originalLineOffsetConverter.getLineCount();
    }

    static class AdjusterToken {
        private static final Comparator<AdjusterToken> COMPARE_BY_START_OFFSET = Comparator.comparingInt(token -> token.startOffset);
        private static final Comparator<AdjusterToken> COMPARE_BY_END_OFFSET = Comparator.comparingInt(token -> token.endOffset);
        private final String text;
        private final int startOffset;
        private final int endOffset;

        private AdjusterToken(String text, int startOffset) {
            this(text, startOffset, startOffset + text.length() - 1);
        }

        private AdjusterToken(String text, int startOffset, int endOffset) {
            this.text = text;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean equals(Object obj) {
            return obj instanceof AdjusterToken && ((AdjusterToken)obj).text.equals(this.text);
        }

        public String toString() {
            return "AdjusterToken{text='" + this.text + "', startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + "}";
        }

        public int hashCode() {
            return this.text.hashCode();
        }
    }
}

