/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass(containedInBackup=true)
@Schema(implementation=SchemaHint.class)
public record CodeScopeName(@NonNull String name) implements Serializable
{
    private static final long serialVersionUID = 1L;
    public static final CodeScopeName DEFAULT = new CodeScopeName("default");

    public CodeScopeName(@NonNull String name) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (Object)"Code scope name must not be empty or null");
        Preconditions.checkArgument((!name.contains(",") ? 1 : 0) != 0, (Object)"Code scope name must not contain ','");
        Preconditions.checkArgument((!name.contains("/") ? 1 : 0) != 0, (Object)"Code scope name must not contain '/'");
    }

    @Override
    @JsonValue
    public @NonNull String toString() {
        return this.name;
    }

    @JsonCreator
    static CodeScopeName getInstance(@NonNull String codeScopeName) {
        return new CodeScopeName(codeScopeName);
    }

    @Schema(extensions={@Extension(name="x-Teamscale", properties={@ExtensionProperty(name="type", value="CodeScopeName"), @ExtensionProperty(name="import", value="ts/commons/CodeScopeName")})})
    public static final class SchemaHint {
        private SchemaHint() {
        }
    }
}

