/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.UUID;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class InternalProjectId
extends ProjectIdBase {
    private static final long serialVersionUID = 1L;

    @JsonCreator
    public InternalProjectId(String projectId) {
        super(projectId);
        if (!projectId.equals("##maintenance##") && !this.isUuidFormat()) {
            throw new IllegalArgumentException("Tried to create an internal project ID from \"" + projectId + "\", which does not fit the expected format. Did you supply a public project ID by mistake?");
        }
    }

    private InternalProjectId() {
        super(UUID.randomUUID().toString());
    }

    public static InternalProjectId create() {
        return new InternalProjectId();
    }

    @Override
    public boolean isInternal() {
        return true;
    }
}

