/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public record MergeRequestIdentifier(@NonNull String repositoryName, long id) implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final char SEPARATOR = '/';

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable MergeRequestIdentifier fromString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Pair parts = StringUtils.splitAtLast((String)value, (char)'/');
        Preconditions.checkNotNull((Object)((String)parts.getSecond()), (String)"Merge request identifier has wrong format: %s", (Object)value);
        return new MergeRequestIdentifier((String)parts.getFirst(), Long.parseLong((String)parts.getSecond()));
    }

    @Override
    @JsonProperty(value="idWithRepository")
    public @NonNull String toString() {
        return this.repositoryName + "/" + this.id;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MergeRequestIdentifier identifier = (MergeRequestIdentifier)other;
        return this.id == identifier.id && Objects.equals(this.repositoryName.toLowerCase(), identifier.repositoryName.toLowerCase());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.repositoryName.toLowerCase(), this.id);
    }
}

