/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class PublicProjectId
extends ProjectIdBase {
    private static final long serialVersionUID = 1L;
    private static final String PROJECT_ID_ALLOWED_CHARACTERS = "-_.a-zA-Z0-9";
    public static final Pattern PROJECT_ID_FORBIDDEN_CHARACTERS_REGEX = Pattern.compile("[^-_.a-zA-Z0-9]+|aliases|ids");
    public static final Pattern PROJECT_ID_REGEX = Pattern.compile("^(?!aliases$)(?!ids$)[-_.a-zA-Z0-9]+$");

    @JsonCreator
    public PublicProjectId(String projectId) {
        super(projectId);
        if (this.isUuidFormat()) {
            throw new IllegalArgumentException("Tried to create a public project ID from \"" + projectId + "\", which does not fit the expected format. Did you supply an internal project ID by mistake?");
        }
    }

    public static boolean isValidId(PublicProjectId publicId) {
        return PROJECT_ID_REGEX.matcher(publicId.toString()).matches();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    public static PublicProjectId of(String projectId) {
        return new PublicProjectId(projectId);
    }

    public static List<PublicProjectId> of(String ... projectIds) {
        return CollectionUtils.map((Object[])projectIds, PublicProjectId::new);
    }

    public static List<PublicProjectId> of(List<String> projectIds) {
        return CollectionUtils.map(projectIds, PublicProjectId::new);
    }

    public static Set<PublicProjectId> of(Set<String> projectIds) {
        return CollectionUtils.mapToSet(projectIds, PublicProjectId::new);
    }
}

