/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.resource.text.filter.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class Deletion
implements Comparable<Deletion>,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="startOffset")
    private final int startOffset;
    @JsonProperty(value="endOffset")
    private final int endOffset;
    @JsonProperty(value="gap")
    private final boolean gap;

    public Deletion(int startOffset, int endOffset, boolean gap) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.gap = gap;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean isGap() {
        return this.gap;
    }

    @Override
    public int compareTo(Deletion other) {
        return this.startOffset - other.startOffset;
    }

    public boolean covers(TextRegionLocation location) {
        return this.startOffset <= location.getRawStartOffset() && location.getRawEndOffset() < this.endOffset;
    }

    public String toString() {
        String gapString = "gap";
        if (!this.gap) {
            gapString = "no gap";
        }
        return this.startOffset + "-" + this.endOffset + " (" + gapString + ")";
    }

    public static List<Deletion> compactDeletions(List<Deletion> deletions) {
        deletions = CollectionUtils.sort(deletions);
        ArrayList<Deletion> result = new ArrayList<Deletion>();
        for (int i = 0; i < deletions.size(); ++i) {
            Deletion deletion = (Deletion)deletions.get(i);
            int startOffset = deletion.startOffset;
            int endOffset = deletion.endOffset;
            boolean gap = deletion.gap;
            while (i + 1 < deletions.size() && ((Deletion)deletions.get((int)(i + 1))).startOffset <= endOffset) {
                Deletion deletion2 = (Deletion)deletions.get(i + 1);
                endOffset = Math.max(endOffset, deletion2.endOffset);
                gap = gap || deletion2.gap;
                ++i;
            }
            result.add(new Deletion(startOffset, endOffset, gap));
        }
        return result;
    }

    public static boolean isFilteredOffset(int offset, Collection<Deletion> filterDeletions) {
        if (filterDeletions == null) {
            return false;
        }
        return filterDeletions.stream().anyMatch(deletion -> deletion.getStartOffset() <= offset && deletion.getEndOffset() > offset);
    }
}

