/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.simulink.builder.MutableMDLSection;
import org.jetbrains.annotations.VisibleForTesting;

public class SLXModelSanitizer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern BLOCK_PORT_PATTERN = Pattern.compile("(\\d+(?::+\\d+)*)#(out|in|trigger|Reset|enable|ifaction|state|lconn|rconn)(?::(\\d+))?");
    private static final Set<String> FLATTENED_MODEL_SUBSECTIONS = new HashSet<String>(Arrays.asList("GraphicalInterface", "UserParameters", "ConfigManagerSettings", "EditorSettings", "SimulationSettings", "Verification", "ExternalMode", "EngineSettings", "ModelReferenceSettings", "ConfigurationSet", "ConcurrentExecutionSettings", "MaskDefaults", "MaskParameterDefaults", "ConfigSet"));
    private static final Set<String> FLATTENING_IGNORED_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("PropName", "ObjectID", "ClassName", "type", "Dimension", "BlockType", "SID", "ValueDimension"));
    private static final Set<String> SPECIAL_PORT_TYPES = new HashSet<String>(Arrays.asList("trigger", "enable", "ifaction", "state", "Reset"));
    private static final Set<String> CONFIG_SET_PARAMETER_WHITELIST = CollectionUtils.asHashSet((Object[])new String[]{"SourceLocation", "SourceName", "SFUnusedDataAndEventsDiag", "SFUnexpectedBacktrackingDiag", "SFUnreachableExecutionPathDiag", "SignalInfNanChecking", "IntegerSaturationMsg", "CheckMatrixSingularityMsg", "IntegerOverflowMsg", "SignalRangeChecking", "UnderspecifiedInitializationDetection", "MergeDetectMultiDrivingBlocksExec", "StrictBusMsg"});
    private static final Set<String> MECHANICS_PORT_TYPES = new HashSet<String>(Arrays.asList("lconn", "rconn"));
    @VisibleForTesting
    public static final Set<String> AUTOSAR_PARAMETERS = CollectionUtils.asHashSet((Object[])new String[]{"Port", "Element", "DataAccessMode"});
    public static final String AUTOSAR_PARAMETER_FORMAT = "AUTOSAR.%s.%s";

    public static void sanitize(MutableMDLSection section, String modelFilename) {
        MutableMDLSection machine;
        section.setParameter("Name", "");
        SLXModelSanitizer.sanitizeFirstModelSectionOfName(section, "Model", modelFilename);
        SLXModelSanitizer.sanitizeFirstModelSectionOfName(section, "Library", modelFilename);
        SLXModelSanitizer.sanitizeFirstModelSectionOfName(section, "Subsystem", modelFilename);
        MutableMDLSection stateflow = "Stateflow".equals(section.getName()) ? section : section.getFirstSubSection("Stateflow");
        if (stateflow != null && (machine = stateflow.getFirstSubSection("machine")) != null) {
            SLXModelSanitizer.sanitizeStateflowSection(stateflow, machine);
        }
    }

    private static void sanitizeFirstModelSectionOfName(MutableMDLSection file, String sectionName, String modelFilename) {
        MutableMDLSection model = file.getFirstSubSection(sectionName);
        if (model != null) {
            SLXModelSanitizer.flattenModel(model);
            SLXModelSanitizer.sanitizeModel(model, modelFilename);
            SLXModelSanitizer.sanitizeLines(model);
        }
    }

    static void flattenModel(MutableMDLSection model) {
        for (MutableMDLSection subSection : (List)model.getSubSections().getValues()) {
            if (!FLATTENED_MODEL_SUBSECTIONS.contains(subSection.getName())) continue;
            SLXModelSanitizer.flattenSection(model, subSection);
        }
    }

    private static void flattenSection(MutableMDLSection model, MutableMDLSection section) {
        if ("ConfigSet".equals(section.getName())) {
            SLXModelSanitizer.flattenConfigSetSection(model, section);
            return;
        }
        for (Map.Entry<String, String> parameter : section.getParameters().entrySet()) {
            if (FLATTENING_IGNORED_PARAMETER_NAMES.contains(parameter.getKey())) continue;
            String parameterKey = parameter.getKey();
            if (AUTOSAR_PARAMETERS.contains(parameter.getKey()) && (parameterKey = SLXModelSanitizer.createAutosarParameterKey(parameterKey, section)) == null) continue;
            model.getParameters().put(parameterKey, parameter.getValue());
        }
        for (MutableMDLSection subSection : (List)section.getSubSections().getValues()) {
            SLXModelSanitizer.flattenSection(model, subSection);
        }
        model.removeSection(section);
    }

    private static String createAutosarParameterKey(String parameterKey, MutableMDLSection section) {
        String parentObjectID = section.getParentSection().getParameter("ObjectID");
        if (parentObjectID == null) {
            LOGGER.error("No parent object ID found in AUTOSAR object in section " + String.valueOf(section));
            return null;
        }
        return String.format(AUTOSAR_PARAMETER_FORMAT, parentObjectID, parameterKey);
    }

    private static void flattenConfigSetSection(MutableMDLSection model, MutableMDLSection section) {
        for (Map.Entry<String, String> parameter : section.getParameters().entrySet()) {
            if (!CONFIG_SET_PARAMETER_WHITELIST.contains(parameter.getKey())) continue;
            model.getParameters().put(parameter.getKey(), parameter.getValue());
        }
        for (MutableMDLSection subSection : (List)section.getSubSections().getValues()) {
            SLXModelSanitizer.flattenConfigSetSection(model, subSection);
        }
        model.removeSection(section);
    }

    private static void sanitizeModel(MutableMDLSection model, String modelFilename) {
        String modelName = model.getParameter("model_");
        if (modelName == null || "$bdroot".equals(modelName)) {
            modelName = FileSystemUtils.getFilenameWithoutExtension((Path)Path.of(modelFilename, new String[0]));
        }
        model.setParameter("Name", modelName);
        String version = model.getParameter("ComputedModelVersion");
        if (version == null) {
            version = "1.0";
        }
        model.setParameter("Version", version);
        MutableMDLSection system = model.getFirstSubSection("System");
        if (system != null) {
            system.setParameter("Name", modelName);
            SLXModelSanitizer.flattenSystemDefaults(model);
        }
    }

    static void flattenSystemDefaults(MutableMDLSection model) {
        MutableMDLSection blockDefaults = model.getFirstSubSection("BlockDefaults");
        MutableMDLSection systemDefaults = model.getFirstSubSection("SystemDefaults");
        if (systemDefaults != null) {
            if (blockDefaults == null) {
                blockDefaults = new MutableMDLSection("BlockDefaults", -1);
                model.addSubSection(blockDefaults);
            }
            for (Map.Entry<String, String> parameter : systemDefaults.getParameters().entrySet()) {
                String key = "System." + parameter.getKey();
                blockDefaults.setParameter(key, parameter.getValue());
            }
            model.removeSection(systemDefaults);
        }
    }

    private static void sanitizeLines(MutableMDLSection container) {
        for (MutableMDLSection subSection : (List)container.getSubSections().getValues()) {
            String name = subSection.getName();
            if ("Line".equals(name) || "Branch".equals(name)) {
                SLXModelSanitizer.sanitizeLine(subSection);
            }
            SLXModelSanitizer.sanitizeLines(subSection);
        }
    }

    static void sanitizeLine(MutableMDLSection lineOrBranch) {
        SLXModelSanitizer.sanitizeLineSrcOrDst(lineOrBranch, "Src", "SrcPort", "SrcBlock");
        SLXModelSanitizer.sanitizeLineSrcOrDst(lineOrBranch, "Dst", "DstPort", "DstBlock");
    }

    private static void sanitizeLineSrcOrDst(MutableMDLSection lineOrBranch, String srcOrDstParameter, String srcOrDstPortParameter, String srcOrDstBlockParameter) {
        String value = lineOrBranch.getParameter(srcOrDstParameter);
        if (value == null) {
            return;
        }
        Matcher matcher = BLOCK_PORT_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return;
        }
        String blockSID = matcher.group(1);
        Object portId = matcher.group(3);
        String portType = matcher.group(2);
        if (SPECIAL_PORT_TYPES.contains(portType)) {
            portId = portType;
        } else if (MECHANICS_PORT_TYPES.contains(portType)) {
            portId = portType + ":" + (String)portId;
        }
        lineOrBranch.setParameter(srcOrDstBlockParameter, blockSID);
        lineOrBranch.setParameter(srcOrDstPortParameter, (String)portId);
        lineOrBranch.removeParameter(srcOrDstParameter);
    }

    private static void sanitizeStateflowSection(MutableMDLSection stateflowModel, MutableMDLSection section) {
        for (MutableMDLSection subSection : (List)section.getSubSections().getValues()) {
            String name = subSection.getName();
            if ("Children".equals(name)) {
                SLXModelSanitizer.sanitizeStateflowSection(stateflowModel, subSection);
                section.removeSection(subSection);
                continue;
            }
            SLXModelSanitizer.sanitizeId(subSection);
            if ("state".equals(name)) {
                SLXModelSanitizer.buildTreeNode(section, subSection);
                SLXModelSanitizer.sanitizeStateflowSection(stateflowModel, subSection);
                SLXModelSanitizer.flattenStateflowSection(stateflowModel, subSection);
                continue;
            }
            if ("chart".equals(name)) {
                SLXModelSanitizer.buildMachineId(section, subSection);
                SLXModelSanitizer.sanitizeStateflowSection(stateflowModel, subSection);
                SLXModelSanitizer.flattenStateflowSection(stateflowModel, subSection);
                continue;
            }
            if (!"data".equals(name) && !"transition".equals(name) && !"junction".equals(name) && !"target".equals(name) && !"event".equals(name)) continue;
            SLXModelSanitizer.buildLinkNode(section, subSection);
            SLXModelSanitizer.sanitizeStateflowSection(stateflowModel, subSection);
            SLXModelSanitizer.flattenStateflowSection(stateflowModel, subSection);
        }
    }

    private static void sanitizeId(MutableMDLSection section) {
        Object ssid = section.getParameter("SSID");
        if (ssid != null) {
            MutableMDLSection parentChart = SLXModelSanitizer.findParentChartSection(section);
            if (parentChart != null) {
                ssid = parentChart.getParameter("id") + ":" + (String)ssid;
            }
            section.setParameter("id", (String)ssid);
            section.removeParameter("SSID");
        }
    }

    private static MutableMDLSection findParentChartSection(MutableMDLSection section) {
        for (MutableMDLSection parent = section.getParentSection(); parent != null; parent = parent.getParentSection()) {
            if (!parent.getName().equals("chart")) continue;
            return parent;
        }
        return null;
    }

    private static void buildTreeNode(MutableMDLSection section, MutableMDLSection subSection) {
        MutableMDLSection parent = section.getParentSection();
        String parentId = parent.getParameter("id");
        if (parentId != null) {
            subSection.setParameter("treeNode", "[" + parentId + "]");
        }
    }

    private static void buildMachineId(MutableMDLSection section, MutableMDLSection subSection) {
        MutableMDLSection parent = section.getParentSection();
        String parentId = parent.getParameter("id");
        if (parentId != null) {
            subSection.setParameter("machine", parentId);
        }
    }

    private static void buildLinkNode(MutableMDLSection section, MutableMDLSection subSection) {
        MutableMDLSection parent = section.getParentSection();
        String parentId = parent.getParameter("id");
        if (parentId != null) {
            subSection.setParameter("linkNode", "[" + parentId + "]");
        }
    }

    private static void flattenStateflowSection(MutableMDLSection stateflowModel, MutableMDLSection section) {
        MutableMDLSection parent = section.getParentSection();
        if (parent != null) {
            parent.removeSection(section);
        }
        stateflowModel.addSubSection(section);
    }
}

