/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class ResolvedIdUtils {
    public static String getResolvedId(SimulinkElementBase element) {
        if (element instanceof SimulinkModel) {
            SimulinkModel model = (SimulinkModel)element;
            ModelDataHandler dataHandler = model.getModelDataHandler();
            if (dataHandler.getParentBlockId() != null && dataHandler.getDiscardedPrefix() == null) {
                return dataHandler.getParentBlockId();
            }
            return SimulinkUtils.escapeSlashes(model.getName());
        }
        String discardedPrefix = element.getModel().getModelDataHandler().getDiscardedPrefix();
        if (discardedPrefix != null && element.getId().equals(discardedPrefix)) {
            return element.getModel().getModelDataHandler().getParentBlockId();
        }
        SimulinkElementBase parent = element.getParent();
        if (parent != null) {
            return ResolvedIdUtils.getResolvedId(parent) + "/" + SimulinkUtils.escapeSlashes(element.getName());
        }
        return SimulinkUtils.escapeSlashes(element.getName());
    }

    public static List<String> getSplitResolvedIdWithResolvedLabels(SimulinkElementBase element) {
        String discardedPrefix = element.getModel().getModelDataHandler().getDiscardedPrefix();
        if (discardedPrefix != null && element.getId().equals(discardedPrefix)) {
            return new ArrayList<String>(Arrays.asList(element.getModel().getModelDataHandler().getParentBlockId().split("/")));
        }
        SimulinkElementBase parent = element.getParent();
        if (parent != null) {
            List<String> idList = ResolvedIdUtils.getSplitResolvedIdWithResolvedLabels(parent);
            idList.add(element.getName());
            return idList;
        }
        return new ArrayList<String>(Collections.singletonList(element.getName()));
    }

    public static String getResolvedIdWithResolvedLabels(SimulinkElementBase element) {
        List<String> splitResolvedId = ResolvedIdUtils.getSplitResolvedIdWithResolvedLabels(element);
        CCSMAssert.isNotEmpty(splitResolvedId, (String)"Split resolved ID list is empty.");
        return StringUtils.concat(splitResolvedId, (String)"/");
    }

    private ResolvedIdUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

