/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTarget;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

public class StateflowMachine
extends StateflowDeclContainerBase<IStateflowElement<?>>
implements IStateflowChartContainer<IStateflowElement<?>> {
    private SimulinkModel model;
    private final ModelDataHandler dataHandler;
    private final IdentityHashSet<StateflowTarget> targets = new IdentityHashSet();
    private final HashMap<String, StateflowChart> charts = new HashMap();

    public StateflowMachine(SimulinkModel model, ModelDataHandler dataHandler) {
        this.model = model;
        this.dataHandler = dataHandler;
        model.setStateflowMachine(this);
    }

    public void addChart(String fqName, StateflowChart chart) {
        this.charts.put(fqName, chart);
        chart.setParent(this);
    }

    public void addTarget(StateflowTarget target) {
        this.targets.add((Object)target);
        target.setParent(this);
    }

    public StateflowChart getChart(String fqName) {
        return this.charts.get(SimulinkUtils.removeEscapedSlashes(fqName));
    }

    @Override
    public UnmodifiableCollection<StateflowChart> getCharts() {
        return CollectionUtils.asUnmodifiable(this.charts.values());
    }

    @Override
    public UnmodifiableCollection<StateflowChart> getCharts(boolean includeCommented) {
        if (includeCommented) {
            return CollectionUtils.asUnmodifiable(this.charts.values());
        }
        return CollectionUtils.asUnmodifiable(this.charts.values().stream().filter(chart -> !StateflowMachine.isChartCommentedOrBelowCommentedAncestor(chart)).collect(Collectors.toList()));
    }

    private static boolean isChartCommentedOrBelowCommentedAncestor(StateflowChart chart) {
        if (StateflowUtils.isCommented(chart)) {
            return true;
        }
        for (SimulinkBlock simulinkBlock = chart.getStateflowBlock(); simulinkBlock != null; simulinkBlock = simulinkBlock.getParent()) {
            if (!SimulinkUtils.isCommentedBlock(simulinkBlock)) continue;
            return true;
        }
        for (Object parentContainer = chart.getParent(); parentContainer != null && parentContainer instanceof StateflowElementBase; parentContainer = parentContainer.getParent()) {
            if (!StateflowUtils.isCommented((StateflowElementBase)parentContainer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StateflowMachine getMachine() {
        return this;
    }

    public SimulinkModel getModel() {
        return this.model;
    }

    public UnmodifiableSet<StateflowTarget> getTargets() {
        return CollectionUtils.asUnmodifiable(this.targets);
    }

    @Override
    public String buildQualifiedName() {
        return this.getModel().buildQualifiedName();
    }

    @Override
    public void remove() {
        CCSMAssert.isTrue((boolean)this.charts.isEmpty(), (String)"All charts must be removed first (via removing the Stateflow blocks).");
        this.model.setStateflowMachine(null);
        this.model = null;
        for (StateflowTarget target : new ArrayList<StateflowTarget>((Collection<StateflowTarget>)this.targets)) {
            target.remove();
        }
    }

    void removeChart(StateflowChart chart) {
        CCSMAssert.isTrue((chart.getMachine() == this ? 1 : 0) != 0, (String)("Machine does not contain chart with name " + String.valueOf(chart)));
        String fqName = chart.getStateflowBlock().getId();
        CCSMAssert.isTrue((this.charts.get(fqName) == chart ? 1 : 0) != 0, (String)"Error in chart storage.");
        this.charts.remove(fqName);
        chart.removeNodes();
        chart.setStateflowBlock(null);
        chart.setParent(null);
    }

    void removeTarget(StateflowTarget target) {
        this.targets.remove((Object)target);
        target.setParent(null);
    }

    @SimulinkTestExclude
    ModelDataHandler getModelDataHandler() {
        return this.dataHandler;
    }
}

