/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.AnnotationLayoutData;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.EInterpreter;
import org.conqat.lib.simulink.model.datahandler.ESimulinkStrokeStyle;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.conqat.lib.simulink.model.datahandler.LineLayoutData;
import org.conqat.lib.simulink.model.datahandler.PortLayoutData;
import org.conqat.lib.simulink.model.datahandler.RectangleLayoutData;
import org.conqat.lib.simulink.util.RendererBase;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkBlockRenderer
extends RendererBase {
    private static final Polygon ARROW_HEAD_POLYGON = new Polygon(new int[]{0, -6, -6}, new int[]{0, 4, -4}, 3);
    private static final int PORT_ARROW_SIZE = 4;
    private static final int UNCONNECTED_LINE_ARROW_SIZE = 6;

    public static BufferedImage renderBlock(SimulinkBlock block) {
        Rectangle canvasRectangle = SimulinkBlockRenderer.determineCanvasRectangle(block);
        BufferedImage image = new BufferedImage(canvasRectangle.width, canvasRectangle.height, 6);
        Graphics2D graphics = SimulinkBlockRenderer.createGraphics(canvasRectangle, image);
        for (SimulinkAnnotation annotation : block.getAnnotations()) {
            SimulinkBlockRenderer.renderAnnotation(annotation, graphics);
        }
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            SimulinkBlockRenderer.renderSubBlock(subBlock, graphics);
        }
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            SimulinkBlockRenderer.renderSubBlockLabel(subBlock, graphics);
        }
        List sortedLines = CollectionUtils.sort(block.getContainedLines(), (Comparator)new Comparator<SimulinkLine>(){

            @Override
            public int compare(SimulinkLine line1, SimulinkLine line2) {
                return line1.toLineString().compareTo(line2.toLineString());
            }
        });
        for (SimulinkLine line : sortedLines) {
            SimulinkBlockRenderer.renderLine(line, graphics);
        }
        return image;
    }

    private static void renderAnnotation(SimulinkAnnotation annotation, Graphics2D graphics) {
        BufferedImage image;
        LabelLayoutData labelData;
        AnnotationLayoutData layoutData = annotation.obtainLayoutData();
        Rectangle position = layoutData.getPosition();
        graphics.setColor(layoutData.getBackgroundColor());
        graphics.fillRect(position.x, position.y, position.width, position.height);
        if (layoutData.isBorderVisible()) {
            graphics.setColor(layoutData.getForegroundColor());
            graphics.drawRect(position.x, position.y, position.width, position.height);
        }
        if ((labelData = annotation.obtainLabelData()) != null) {
            SimulinkBlockRenderer.renderLabel(labelData, layoutData.getHorizontalAlignment(), graphics, annotation.getInterpreter() == EInterpreter.RICH);
        }
        if (annotation.containsImage() && (image = annotation.getImage()) != null) {
            graphics.drawImage(image.getScaledInstance(position.width, position.height, 1), position.x, position.y, null);
        }
    }

    private static void renderSubBlock(SimulinkBlock subBlock, Graphics2D graphics) {
        SimulinkBlockRenderer.renderPorts(subBlock.getInPorts(), graphics);
        SimulinkBlockRenderer.renderPorts(subBlock.getOutPorts(), graphics);
        BlockLayoutData layoutData = subBlock.obtainBlockLayoutData();
        Rectangle position = layoutData.getPosition();
        boolean rounded = SimulinkUtils.isRoundSum(subBlock) || SimulinkUtils.isRoundFunctionCallSplitBlock(subBlock);
        graphics.setColor(layoutData.getBackgroundColor());
        if (rounded) {
            graphics.fillOval(position.x, position.y, position.width, position.height);
        } else {
            graphics.fillRect(position.x, position.y, position.width, position.height);
        }
        graphics.setColor(layoutData.getForegroundColor());
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(layoutData.getStroke());
        if (rounded) {
            graphics.drawOval(position.x, position.y, position.width, position.height);
        } else {
            graphics.drawRect(position.x, position.y, position.width, position.height);
        }
        graphics.setStroke(oldStroke);
    }

    private static void renderSubBlockLabel(SimulinkBlock subBlock, Graphics2D graphics) {
        SimulinkBlockRenderer.renderLabel(subBlock.obtainLabelLayoutData(), graphics);
        SimulinkBlockRenderer.renderLabel(subBlock.obtainSubLabelData(), graphics);
        SimulinkBlockRenderer.renderLabel(subBlock.obtainInnerLabelData(), graphics);
        SimulinkBlockRenderer.renderPortLabels(subBlock.getInPorts(), graphics);
        SimulinkBlockRenderer.renderPortLabels(subBlock.getOutPorts(), graphics);
    }

    private static void renderPorts(Collection<? extends SimulinkPortBase> ports, Graphics2D graphics) {
        for (SimulinkPortBase simulinkPortBase : ports) {
            SimulinkBlockRenderer.renderPort(simulinkPortBase, graphics);
        }
    }

    private static void renderPort(SimulinkPortBase port, Graphics2D graphics) {
        if (port.isConnected()) {
            return;
        }
        PortLayoutData layoutData = port.obtainLayoutData();
        graphics.setColor(layoutData.getColor());
        int xOffset = 0;
        if (port instanceof SimulinkOutPort) {
            xOffset = 5;
        }
        AffineTransform oldTransform = graphics.getTransform();
        graphics.translate(layoutData.getPosition().x, layoutData.getPosition().y);
        graphics.rotate(-layoutData.getDirection() * Math.PI / 180.0);
        graphics.translate(xOffset, 0);
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.drawLine(-4, 4, 0, 0);
        graphics.drawLine(-4, -4, 0, 0);
        graphics.setStroke(oldStroke);
        graphics.setTransform(oldTransform);
    }

    private static void renderPortLabels(Collection<? extends SimulinkPortBase> ports, Graphics2D graphics) {
        for (SimulinkPortBase simulinkPortBase : ports) {
            SimulinkBlockRenderer.renderLabel(simulinkPortBase.obtainLabelData(), graphics);
        }
    }

    private static void renderLine(SimulinkLine line, Graphics2D graphics) {
        LineLayoutData layoutData = line.obtainLayoutData();
        graphics.setColor(layoutData.getColor());
        Stroke oldStroke = graphics.getStroke();
        if (line.hasUnconnectedEndpoint()) {
            graphics.setStroke(ESimulinkStrokeStyle.UNCONNECTED_LINE_STROKE.getStroke());
        }
        List<Point> points = layoutData.getPoints();
        for (int i = 1; i < points.size(); ++i) {
            Point from = points.get(i - 1);
            Point to = points.get(i);
            graphics.drawLine(from.x, from.y, to.x, to.y);
        }
        if (points.size() > 1) {
            Point last = (Point)CollectionUtils.getLast(points);
            Point previous = points.get(points.size() - 2);
            SimulinkBlockRenderer.renderArrow(graphics, last, previous, last, line.getDstPort() != null);
            if (line.getSrcPort() == null) {
                SimulinkBlockRenderer.renderArrow(graphics, points.get(0), points.get(0), points.get(1), false);
            }
        }
        graphics.setStroke(oldStroke);
        line.obtainAllLabelData().forEach(label -> SimulinkBlockRenderer.renderLabel(label, graphics));
    }

    private static void renderArrow(Graphics2D graphics, Point position, Point lineStart, Point lineEnd, boolean filled) {
        AffineTransform oldTransform = graphics.getTransform();
        double theta = Math.atan2(lineEnd.y - lineStart.y, lineEnd.x - lineStart.x);
        graphics.translate(position.x, position.y);
        graphics.rotate(theta);
        if (filled) {
            graphics.fillPolygon(ARROW_HEAD_POLYGON);
        } else {
            graphics.drawLine(-6, 6, 0, 0);
            graphics.drawLine(-6, -6, 0, 0);
        }
        graphics.setTransform(oldTransform);
    }

    private static Rectangle determineCanvasRectangle(SimulinkBlock block) {
        Object layoutData;
        Rectangle canvasRectangle = null;
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            canvasRectangle = SimulinkBlockRenderer.enlargeCanvasRectangle(subBlock, canvasRectangle);
        }
        for (SimulinkAnnotation annotation : block.getAnnotations()) {
            layoutData = annotation.obtainLayoutData();
            if (canvasRectangle == null) {
                canvasRectangle = ((RectangleLayoutData)layoutData).getPosition();
                continue;
            }
            canvasRectangle.add(((RectangleLayoutData)layoutData).getPosition());
        }
        if (canvasRectangle == null) {
            return new Rectangle(10, 10);
        }
        for (SimulinkLine line : block.getContainedLines()) {
            layoutData = line.obtainLayoutData();
            for (Point point : ((LineLayoutData)layoutData).getPoints()) {
                canvasRectangle.add(point);
            }
        }
        canvasRectangle.grow(10, 10);
        return canvasRectangle;
    }

    private static Rectangle enlargeCanvasRectangle(SimulinkBlock subBlock, Rectangle canvasRectangle) {
        BlockLayoutData layoutData = subBlock.obtainBlockLayoutData();
        if (canvasRectangle == null) {
            canvasRectangle = layoutData.getPosition();
        } else {
            canvasRectangle.add(layoutData.getPosition());
        }
        SimulinkBlockRenderer.enlargeCanvasRectangleForLabel(canvasRectangle, subBlock.obtainLabelLayoutData());
        SimulinkBlockRenderer.enlargeCanvasRectangleForLabel(canvasRectangle, subBlock.obtainSubLabelData());
        return canvasRectangle;
    }

    private static void enlargeCanvasRectangleForLabel(Rectangle canvasRectangle, LabelLayoutData labelData) {
        if (labelData == null) {
            return;
        }
        Point labelPosition = labelData.getPosition();
        canvasRectangle.add(labelPosition);
        Rectangle bounds = LayoutHandlerBase.determineTextBounds(labelData.getText(), labelData.getFont().getAwtFont());
        canvasRectangle.add(new Point(labelPosition.x + bounds.width, labelPosition.y + bounds.height));
    }
}

