/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai;

import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="ai-engine-usage", valueClasses={Long.class})
public class AiEngineUsageIndex
extends IndexBase
implements IGlobalIndex {
    public static final String NAME = "ai-engine-usage";

    public AiEngineUsageIndex(IStore store) {
        super(store);
    }

    public void updateUsages(PairList<String, Long> namesAndValues) throws StorageException {
        this.store.performWithLock(() -> {
            List currentValues = this.store.getWithStrings(namesAndValues.extractFirstList());
            this.store.putWithStrings(AiEngineUsageIndex.calculateUpdatedValues(namesAndValues, currentValues));
        }, "update-lock");
    }

    private static PairList<String, byte[]> calculateUpdatedValues(PairList<String, Long> namesAndValues, List<byte[]> currentValues) {
        PairList result = new PairList(namesAndValues.size());
        for (int i = 0; i < namesAndValues.size(); ++i) {
            long newValue = (Long)namesAndValues.getSecond(i);
            if (currentValues.get(i) != null) {
                newValue += ByteArrayUtils.byteArrayToLong((byte[])currentValues.get(i));
            }
            result.add((Object)((String)namesAndValues.getFirst(i)), (Object)ByteArrayUtils.longToByteArray((long)newValue));
        }
        return result;
    }

    public Map<String, Long> getUsageData() throws StorageException {
        return StorageUtils.listStringKeysAndValues((IStore)this.store).mapSecond(ByteArrayUtils::byteArrayToLong).toMap();
    }
}

