/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.google;

import com.google.auth.oauth2.GoogleCredentials;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class GoogleAiClientBase<T extends IRetrofitApi>
implements ILlmCompleter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<T> serviceClass;
    private final String baseUrl;
    private final GoogleCredentials credentials;
    private String currentToken;
    private T service;
    protected final double temperature;
    protected final @Nullable BiConsumer<String, Long> usageReporter;

    public GoogleAiClientBase(String project, String location, String credentialsJson, double temperature, @Nullable BiConsumer<String, Long> usageReporter, Class<T> serviceClass) throws IOException {
        this.serviceClass = serviceClass;
        this.baseUrl = "https://" + location + "-aiplatform.googleapis.com/v1/projects/" + project + "/locations/" + location + "/";
        this.credentials = GoogleAiClientBase.buildCredentials(credentialsJson);
        this.temperature = temperature;
        this.usageReporter = usageReporter;
    }

    private static GoogleCredentials buildCredentials(String credentialsJson) throws IOException {
        GoogleCredentials credentials = StringUtils.isEmpty((String)credentialsJson) ? GoogleCredentials.getApplicationDefault() : GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(StringUtils.stringToBytes((String)credentialsJson)));
        return credentials.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
    }

    private T createService(String bearerToken) {
        return (T)Retrofit.builder((String)this.baseUrl).withBearerAuthentication(bearerToken).withInteractionLogger(LOGGER).create(this.serviceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T ensureService() throws ServiceCallException {
        GoogleCredentials googleCredentials = this.credentials;
        synchronized (googleCredentials) {
            try {
                this.credentials.refreshIfExpired();
            }
            catch (IOException e) {
                throw new ServiceCallException((Throwable)e);
            }
            String token = this.credentials.getAccessToken().getTokenValue();
            if (!token.equals(this.currentToken)) {
                this.currentToken = token;
                this.service = this.createService(this.currentToken);
            }
        }
        return this.service;
    }
}

