/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum EMetricSchemaSource {
    CODE_METRICS(UniformPath.EType.CODE, ""),
    NON_CODE_METRICS(UniformPath.EType.NON_CODE),
    TEST_IMPLEMENTATION_METRICS(UniformPath.EType.TEST_IMPLEMENTATION),
    TEST_EXECUTION_METRICS(UniformPath.EType.TEST_EXECUTION),
    TEST_QUERY_METRICS(UniformPath.EType.TEST_QUERY),
    ISSUE_METRICS(UniformPath.EType.ISSUE_QUERY),
    SPEC_ITEM_METRICS(UniformPath.EType.SPEC_ITEM_QUERY);

    private final UniformPath.EType pathType;
    private final String pathPrefix;

    private EMetricSchemaSource(UniformPath.EType pathType) {
        this(pathType, pathType.getPrefix());
    }

    private EMetricSchemaSource(UniformPath.EType pathType, String prefix) {
        this.pathType = pathType;
        this.pathPrefix = prefix;
    }

    public UniformPath.EType getPathType() {
        return this.pathType;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public boolean isSubPathValid(String subPath) {
        if (this.pathPrefix.isEmpty()) {
            return true;
        }
        if (StringUtils.isEmpty((String)subPath)) {
            return false;
        }
        return subPath.startsWith(this.pathPrefix);
    }

    public static EMetricSchemaSource determineFromSubPath(@NonNull String subPath) {
        for (EMetricSchemaSource metricSchemaSource : EMetricSchemaSource.values()) {
            if (metricSchemaSource == CODE_METRICS || !subPath.startsWith(metricSchemaSource.getPathPrefix())) continue;
            return metricSchemaSource;
        }
        return CODE_METRICS;
    }
}

