/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import eu.cqse.check.framework.scanner.ELanguage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class AnalysisConfigurationBase
extends ConfigurationBase {
    @JsonProperty(value="metrics")
    private final CodeScopeAware<Set<MetricDescriptor>> metrics = CodeScopeAware.empty();
    @JsonProperty(value="findings")
    private final CodeScopeAware<List<FindingDescriptor>> findings = CodeScopeAware.empty();
    protected static final String ASSESSMENT_TOLERATION_DESCRIPTION = " The assessment is independent of findings being tolerated or not.";

    @Override
    @Deprecated
    protected void autoExpose() {
        super.autoExpose();
    }

    @Override
    protected void autoExpose(CodeScopeName codeScopeName) {
        super.autoExpose(codeScopeName);
    }

    @Override
    protected void exposeField(CodeScopeName codeScopeName, Field field) throws ReflectiveOperationException {
        field.setAccessible(true);
        Class<?> type = field.getType();
        if (type == MetricDescriptor.class) {
            this.addMetricDescriptor((MetricDescriptor)field.get(this), codeScopeName);
        } else if (type == FindingDescriptor.class) {
            this.addFindingDescriptor((FindingDescriptor)field.get(this), codeScopeName);
        } else {
            if (type == CodeScopeAware.class) {
                Class<?> codeScopeParameterType = CodeScopeAware.getTypeOfCodeScopeParameter(field);
                if (codeScopeParameterType == MetricDescriptor.class) {
                    CodeScopeAware<?> codeScopeObject = this.getCodeScopeObject(field.getName());
                    MetricDescriptor copiedDefaultMetricDescriptor = new MetricDescriptor((MetricDescriptor)codeScopeObject.defaultValue());
                    codeScopeObject.setGenericValue(codeScopeName, copiedDefaultMetricDescriptor);
                    this.addMetricDescriptor(copiedDefaultMetricDescriptor, codeScopeName);
                } else if (codeScopeParameterType == FindingDescriptor.class) {
                    CodeScopeAware<?> codeScopeObject = this.getCodeScopeObject(field.getName());
                    FindingDescriptor copiedDefaultFindingDescriptor = new FindingDescriptor((FindingDescriptor)codeScopeObject.defaultValue());
                    codeScopeObject.setGenericValue(codeScopeName, copiedDefaultFindingDescriptor);
                    this.addFindingDescriptor(copiedDefaultFindingDescriptor, codeScopeName);
                }
            }
            super.exposeField(codeScopeName, field);
        }
    }

    protected void addMetricDescriptor(MetricDescriptor metric, CodeScopeName codeScopeName) {
        if (!this.metrics.contains(codeScopeName)) {
            this.metrics.setValue(codeScopeName, new HashSet());
        }
        this.metrics.getValue(codeScopeName).add(metric);
        metric.setConfiguration(this);
    }

    public UnmodifiableList<MetricDescriptor> getProvidedMetrics(CodeScopeName codeScopeName) {
        if (!this.metrics.contains(codeScopeName)) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.metrics.getValue(codeScopeName).stream().toList());
    }

    protected void addFindingDescriptor(FindingDescriptor finding, CodeScopeName codeScopeName) {
        finding.setConfiguration(this);
        if (!this.findings.contains(codeScopeName)) {
            this.findings.setValue(codeScopeName, new ArrayList());
        }
        this.findings.getValue(codeScopeName).add(finding);
    }

    @Deprecated
    protected void addFindingDescriptor(FindingDescriptor finding) {
        this.addFindingDescriptor(finding, CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public UnmodifiableList<FindingDescriptor> getProvidedFindings(CodeScopeName codeScopeName) {
        if (!this.findings.contains(codeScopeName)) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.findings.getValue(codeScopeName));
    }

    public boolean isCoreConfiguration() {
        return false;
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return CollectionUtils.emptyList();
    }

    public abstract void registerQualityIndicators(ConfigurationTemplate var1, Set<ELanguage> var2, Set<EAnalysisTool> var3) throws ProjectConfigurationException;

    public void applyQualityIndicatorOptions(String qualityIndicatorName, ProjectCreationProxy proxy) throws ProjectConfigurationException {
    }

    public ConfigOptionDescriptorBase getOptionForField(String fieldName, CodeScopeName codeScopeName) {
        ConfigOptionDescriptorBase option = (ConfigOptionDescriptorBase)((Map)this.optionLookup.getValue(codeScopeName)).get(fieldName);
        CCSMAssert.isTrue((option != null ? 1 : 0) != 0, (String)("Option not found for field " + fieldName));
        return option;
    }

    @Deprecated
    public ConfigOptionDescriptorBase getOptionForField(String fieldName) {
        return this.getOptionForField(fieldName, CodeScopeAware.DEFAULT_CODE_SCOPE);
    }
}

