/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public record CodeScopeAware<T>(@NonNull LinkedHashMap<CodeScopeName, T> parameter, @Nullable T defaultValue) implements Serializable,
Iterable<Map.Entry<CodeScopeName, T>>,
ITriggerParameter
{
    public static final CodeScopeName DEFAULT_CODE_SCOPE = CodeScopeName.DEFAULT;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;

    public CodeScopeAware(@NonNull LinkedHashMap<CodeScopeName, T> parameter, @Nullable T defaultValue) {
        Preconditions.checkNotNull(parameter, (Object)"Code scope parameter map must not be null");
        Preconditions.checkArgument((!parameter.containsKey(null) ? 1 : 0) != 0, (Object)"Code scope parameter map must not contain null keys");
    }

    public static <T> @NonNull CodeScopeAware<T> empty() {
        return new CodeScopeAware<Object>(new LinkedHashMap(), null);
    }

    public static <T> @NonNull CodeScopeAware<T> emptyWithDefault(@NonNull T defaultValue) {
        Preconditions.checkNotNull(defaultValue, (Object)"Default value for code scope parameter must not be null");
        return new CodeScopeAware(new LinkedHashMap(), defaultValue);
    }

    public static <T> @NonNull CodeScopeAware<T> defaultCodeScopeWithValue(@NonNull T defaultValue) {
        Preconditions.checkNotNull(defaultValue, (Object)"Default value for code scope parameter must not be null");
        LinkedHashMap<CodeScopeName, T> parameter = new LinkedHashMap<CodeScopeName, T>();
        parameter.put(DEFAULT_CODE_SCOPE, defaultValue);
        return new CodeScopeAware(parameter, defaultValue);
    }

    public static <T> @NonNull CodeScopeAware<T> from(@NonNull CodeScopeName codeScopeName, T valueInCodeScope) {
        Preconditions.checkNotNull((Object)codeScopeName, (Object)"Code scope name must not be null");
        LinkedHashMap<CodeScopeName, T> parameter = new LinkedHashMap<CodeScopeName, T>();
        parameter.put(codeScopeName, valueInCodeScope);
        return new CodeScopeAware<Object>(parameter, null);
    }

    public static <T> @NonNull CodeScopeAware<T> fromWithDefault(@NonNull CodeScopeName codeScopeName, T valueInCodeScope, @NonNull T defaultValue) {
        Preconditions.checkNotNull((Object)codeScopeName, (Object)"Code scope name must not be null");
        Preconditions.checkNotNull(defaultValue, (Object)"Default value for code scope parameter must not be null");
        LinkedHashMap<CodeScopeName, T> parameter = new LinkedHashMap<CodeScopeName, T>();
        parameter.put(codeScopeName, valueInCodeScope);
        return new CodeScopeAware(parameter, defaultValue);
    }

    public static <T> @NonNull CodeScopeAware<T> fromPairList(@NonNull PairList<CodeScopeName, T> pairList) {
        Preconditions.checkNotNull(pairList, (Object)"Pair list for code scope aware construction must not be null");
        LinkedHashMap<CodeScopeName, Object> parameter = new LinkedHashMap<CodeScopeName, Object>();
        for (Pair pair : pairList) {
            Preconditions.checkNotNull((Object)((CodeScopeName)pair.getFirst()), (Object)"Code scope name must not be null");
            parameter.put((CodeScopeName)pair.getFirst(), pair.getSecond());
        }
        return new CodeScopeAware<Object>(parameter, null);
    }

    public static <T> @NonNull CodeScopeAware<T> fromMap(@NonNull Map<CodeScopeName, T> map) {
        Preconditions.checkNotNull(map, (Object)"Map for code scope aware construction must not be null");
        return new CodeScopeAware<Object>(new LinkedHashMap<CodeScopeName, T>(map), null);
    }

    public static @NonNull Class<?> getTypeOfCodeScopeParameter(@NonNull Field field) {
        Preconditions.checkNotNull((Object)field, (Object)"field must not be null");
        Preconditions.checkArgument((boolean)CodeScopeAware.class.isAssignableFrom(field.getType()), (String)"expected type CodeScopeAware, but was '%s'", field.getType());
        Type[] genericTypeArguments = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        Verify.verify((genericTypeArguments.length == 1 ? 1 : 0) != 0, (String)"expected exactly one generic type argument for class CodeScopeAware, but got %s", (int)genericTypeArguments.length);
        Type actualType = genericTypeArguments[0];
        if (actualType instanceof ParameterizedType) {
            actualType = ((ParameterizedType)actualType).getRawType();
        }
        return (Class)actualType;
    }

    public static <T> @NonNull CodeScopeAware<T> sameForAll(@NonNull SequencedCollection<CodeScopeName> codeScopeNames, T value) {
        CodeScopeAware codeScopeAware = CodeScopeAware.empty();
        codeScopeNames.forEach(codeScopeName -> codeScopeAware.setValue((CodeScopeName)codeScopeName, value));
        return codeScopeAware;
    }

    private void logFallbackToDefaultValue(CodeScopeName codeScope, Level logLevel) {
        if (!LOGGER.isEnabled(logLevel)) {
            return;
        }
        String typeName = "null";
        if (this.defaultValue != null) {
            typeName = this.defaultValue.getClass().getSimpleName();
        }
        Exception stacktrace = new Exception("Stack Trace Info");
        LOGGER.log(logLevel, "Falling back to default value for code scope: '{}' -> '{}' [{}]", (Object)codeScope, this.defaultValue, (Object)typeName, (Object)stacktrace);
    }

    public T getValue(CodeScopeName codeScope) {
        return this.getValueWithDefaultFallbackAndLogging(codeScope, Level.ERROR);
    }

    public @Nullable T getValueOrNull(CodeScopeName codeScope) {
        return this.parameter.get(codeScope);
    }

    public T getValueWithDefault(CodeScopeName codeScope) {
        return this.getValueWithDefaultFallbackAndLogging(codeScope, Level.DEBUG);
    }

    private T getValueWithDefaultFallbackAndLogging(CodeScopeName codeScope, Level debug) {
        if (this.parameter.containsKey(codeScope)) {
            return this.parameter.get(codeScope);
        }
        if (this.defaultValue != null) {
            this.logFallbackToDefaultValue(codeScope, debug);
            return this.defaultValue;
        }
        throw new NoSuchElementException("No value for code scope '%s' and no default value present".formatted(codeScope));
    }

    public @NonNull T getOrComputeValue(CodeScopeName codeScope, Function<? super CodeScopeName, @NonNull ? extends T> valueFactory) {
        return (T)this.parameter.computeIfAbsent(codeScope, valueFactory.andThen(value -> Objects.requireNonNull(value, () -> "Computed a null value for code scope '%s'".formatted(codeScope))));
    }

    public void merge(CodeScopeAware<T> other, BinaryOperator<T> mergeFunction) {
        for (CodeScopeName codeScopeName : other.getCodeScopeNames()) {
            T otherValue = other.getValue(codeScopeName);
            T existing = this.getValueOrNull(codeScopeName);
            if (existing == null) {
                this.setValue(codeScopeName, otherValue);
                continue;
            }
            this.setValue(codeScopeName, mergeFunction.apply(existing, otherValue));
        }
    }

    public boolean contains(CodeScopeName codeScope) {
        return this.parameter.containsKey(codeScope);
    }

    public void setValue(@NonNull CodeScopeName codeScope, T value) {
        Preconditions.checkNotNull((Object)codeScope, (Object)"Code scope name must not be null");
        this.parameter.put(codeScope, value);
    }

    public void setGenericValue(@NonNull CodeScopeName codeScope, Object value) {
        Preconditions.checkNotNull((Object)codeScope, (Object)"Code scope name must not be null");
        this.setValue(codeScope, value);
    }

    public @NonNull @Unmodifiable List<T> getValues() {
        return this.parameter.values().stream().toList();
    }

    public @NonNull @Unmodifiable List<CodeScopeName> getCodeScopeNames() {
        return this.parameter.keySet().stream().toList();
    }

    public T getValueForDefaultCodeScope() {
        return this.getValue(DEFAULT_CODE_SCOPE);
    }

    public @Nullable T removeValue(@NonNull CodeScopeName codeScope) {
        Preconditions.checkNotNull((Object)codeScope, (Object)"Code scope name must not be null");
        return (T)this.parameter.remove(codeScope);
    }

    @Override
    public @NonNull Iterator<Map.Entry<CodeScopeName, T>> iterator() {
        return this.parameter.entrySet().iterator();
    }

    public <S> @NonNull CodeScopeAware<S> map(@NonNull Function<T, S> transformingFunction) {
        CodeScopeAware<Object> result = this.defaultValue != null ? CodeScopeAware.emptyWithDefault(transformingFunction.apply(this.defaultValue)) : CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : this.getCodeScopeNames()) {
            T thisValue = this.getValue(codeScopeName);
            S transformedValue = transformingFunction.apply(thisValue);
            result.setValue(codeScopeName, transformedValue);
        }
        return result;
    }

    public void clear() {
        this.parameter.clear();
    }

    public CodeScopeAware<T> copy() {
        return new CodeScopeAware<T>(new LinkedHashMap<CodeScopeName, T>(this.parameter), this.defaultValue);
    }
}

