/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.google.common.collect.ImmutableSet;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.ESoftwareCompositionAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ESystemType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import java.util.Collection;
import java.util.EnumSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum EConnectorType {
    SYSTEM_TYPE("General System Types", ESystemType.class),
    SOURCE_CODE_REPOSITORY("Source Code Repository", ERepositoryConnector.class),
    ISSUE_TRACKER("Issue Tracker", EIssueTracker.class),
    REQUIREMENTS_MANAGEMENT_TOOL("Requirements Management Tool", ERequirementsManagementTool.class),
    SOFTWARE_COMPOSITION_ANALYSIS_TOOL("Software Composition Analysis (SCA) Tool", ESoftwareCompositionAnalysisTool.class);

    public final String displayName;
    public final Class<? extends IConnectorEnum<?>> connectorEnumClass;
    private static final EnumSet<EConnectorType> ALLOWED_CONNECTOR_TYPES_FOR_PROJECT_USE;

    private EConnectorType(String name, Class<? extends IConnectorEnum<?>> connectorEnumClass) {
        this.displayName = name;
        this.connectorEnumClass = connectorEnumClass;
    }

    public static Collection<EConnectorType> getAllowedConnectorTypes() {
        return ImmutableSet.copyOf(ALLOWED_CONNECTOR_TYPES_FOR_PROJECT_USE);
    }

    static {
        ALLOWED_CONNECTOR_TYPES_FOR_PROJECT_USE = EnumSet.complementOf(EnumSet.of(SYSTEM_TYPE));
    }
}

