/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.teamscale.core.authenticate.index.OAuthStateIndex;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class OAuthStateUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TOKEN_BYTE_LENGTH = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private OAuthStateUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static String generateOAuthRequestId() {
        return OAuthStateUtils.generateSecureRandomToken();
    }

    public static String generateCSRFToken() {
        return OAuthStateUtils.generateSecureRandomToken();
    }

    private static @NonNull String generateSecureRandomToken() {
        byte[] randomBytes = new byte[32];
        SECURE_RANDOM.nextBytes(randomBytes);
        String token = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        CCSMAssert.isNotNull((Object)token, (String)"Generated token must not be null");
        return token;
    }

    public static boolean hasValidTokenFormat(@Nullable String token) {
        return !StringUtils.isEmpty((CharSequence)token) && token.length() >= 20 && token.length() <= 100;
    }

    public static void storeCsrfToken(@NonNull String csrfToken, String sessionId, OAuthStateIndex stateIndex) throws StorageException {
        stateIndex.storeState(csrfToken, sessionId);
    }

    public static void validateCsrfToken(@Nullable String csrfToken, String currentSessionContext, @NonNull OAuthStateIndex stateIndex) throws StorageException {
        if (StringUtils.isEmpty((CharSequence)csrfToken)) {
            LOGGER.error("Empty CSRF token received.");
            throw new IllegalArgumentException("Empty CSRF security token.");
        }
        if (!OAuthStateUtils.hasValidTokenFormat(csrfToken)) {
            LOGGER.error("Invalid CSRF token format received: token length={}", (Object)csrfToken.length());
            throw new IllegalArgumentException("Invalid security token format.");
        }
        String storedSessionContext = stateIndex.validateAndConsume(csrfToken);
        if (storedSessionContext == null) {
            LOGGER.error("CSRF token validation failed: token not found or expired");
            throw new IllegalArgumentException("Security token expired or invalid.");
        }
        if (!currentSessionContext.equals(storedSessionContext)) {
            LOGGER.error("CSRF token validation failed: session mismatch. Expected: {}, Got: {}", (Object)storedSessionContext, (Object)currentSessionContext);
            throw new IllegalArgumentException("Session mismatch.");
        }
    }
}

