/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolProviderBase;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.authenticate.crowd.CrowdGroupAutoCompletionStrategy;
import com.teamscale.core.authenticate.crowd.CrowdImportGroupsStrategy;
import com.teamscale.core.authenticate.crowd.CrowdImportUsersStrategy;
import com.teamscale.core.authenticate.crowd.CrowdServerDescription;
import com.teamscale.core.authenticate.crowd.CrowdSynchronizeGroupsAsyncStrategy;
import com.teamscale.core.authenticate.crowd.CrowdSynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.crowd.CrowdSynchronizeUsersStrategy;
import com.teamscale.core.authenticate.crowd.CrowdUserAutoCompletionStrategy;
import com.teamscale.core.runtime.impl.progress.GlobalAnalysisProgressIndex;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.FunctionWithException;

public class CrowdProvider
extends AuthenticationToolProviderBase<CrowdServerDescription> {
    public CrowdProvider(GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) {
        super(globalStorageSystem, messageBroker);
    }

    @Override
    public IImportUsersStrategy createImportUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new CrowdImportUsersStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.getMessageBroker());
    }

    @Override
    public IImportGroupsStrategy createImportGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new CrowdImportGroupsStrategy(this.getServer(serverName), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(UserIndex.class), this.getMessageBroker(), (FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException>)((FunctionWithException)x$0 -> this.getToolProvider((EAuthenticationTool)((Object)x$0))));
    }

    @Override
    public ISynchronizeUsersStrategy createSynchronizeUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new CrowdSynchronizeUsersStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.getMessageBroker());
    }

    @Override
    public ISynchronizeGroupsStrategy createSynchronizeGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new CrowdSynchronizeGroupsAsyncStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(GlobalAnalysisProgressIndex.class), this.createImportGroupsStrategy(serverName), this.getMessageBroker());
    }

    @Override
    public ISynchronizeUserGroupsStrategy createSynchronizeUserGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new CrowdSynchronizeUserGroupsStrategy(this.getServer(serverName), this.openGlobalIndex(UserGroupIndex.class));
    }

    @Override
    public IAutoCompletionStrategy createUserAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new CrowdUserAutoCompletionStrategy(this.getServer(serverName));
    }

    @Override
    public IAutoCompletionStrategy createGroupAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new CrowdGroupAutoCompletionStrategy(this.getServer(serverName));
    }

    @Override
    public Class<CrowdServerDescription> getServerDescriptionClass() {
        return CrowdServerDescription.class;
    }

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.CROWD;
    }
}

