/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ToolAuthenticatorBase;
import com.teamscale.core.authenticate.ldap.LDAPServerDescription;
import com.teamscale.core.authenticate.ldap.LDAPUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public class LDAPAuthenticator
extends ToolAuthenticatorBase<LDAPServerDescription> {
    public static final String IDENTIFIER = LDAPAuthenticator.class.getSimpleName();
    private static final Logger LOGGER = LogManager.getLogger();

    public LDAPAuthenticator() {
        super(EAuthenticationTool.LDAP, LDAPServerDescription.class);
    }

    @Override
    public String getAuthenticatorIdentifier() {
        return IDENTIFIER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean authenticate(NamedServer<LDAPServerDescription> server, User user, byte[] password, ServerOptionIndex optionIndex) throws StorageException {
        if (!server.serverDescription().loginEnabled) {
            return false;
        }
        String dn = null;
        try (LDAPConnection connection = null;){
            dn = LDAPUtils.getUserDN(server.serverDescription(), user, server.name(), optionIndex);
            if (dn == null) {
                boolean bl = false;
                return bl;
            }
            connection = LDAPUtils.createSingleConnection(server.serverDescription());
            SimpleBindRequest bindRequest = new SimpleBindRequest(dn, password);
            BindResult result = connection.bind((BindRequest)bindRequest);
            Arrays.fill(password, (byte)0);
            boolean bl = LDAPAuthenticator.determineResultSuccess(result);
            return bl;
        }
    }

    private static boolean determineResultSuccess(BindResult result) {
        ResultCode resultCode = result.getResultCode();
        if (resultCode.equals((Object)ResultCode.SUCCESS)) {
            return true;
        }
        LOGGER.warn("LDAP login failed: " + resultCode.toString() + "\n" + result.toString());
        return false;
    }
}

