/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.openid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="openid-sub-sid", options={EStorageOption.ENCRYPTED}, valueClasses={LoginData.class})
public class OpenIdSessionIndex
extends IndexBase
implements IGlobalIndex {
    public static final String NAME = "openid-sub-sid";
    private static final String TEAMSCALE_USER_KEY_SUFFIX = ":teamscale-user";
    private static final String OPENID_SUB_KEY_SUFFIX = ":sub";
    private static final String OPENID_SID_KEY_SUFFIX = ":sid";

    public OpenIdSessionIndex(IStore store) {
        super(store);
    }

    public Optional<LoginData> getLoginDataForUser(String username) throws StorageException {
        return Optional.ofNullable((LoginData)StorageUtils.deserialize((byte[])this.store.getWithString(OpenIdSessionIndex.getTeamscaleUserKey(username))));
    }

    public Optional<String> getUserForSub(String sub) throws StorageException {
        return Optional.ofNullable((String)((Object)StorageUtils.deserialize((byte[])this.store.getWithString(OpenIdSessionIndex.getOpenIdSubKey(sub)))));
    }

    public Optional<String> getUserForSid(String sid) throws StorageException {
        return Optional.ofNullable((String)((Object)StorageUtils.deserialize((byte[])this.store.getWithString(OpenIdSessionIndex.getOpenIdSidKey(sid)))));
    }

    public void storeLoginDataForUser(String username, LoginData loginData) throws StorageException {
        this.store.putWithString(OpenIdSessionIndex.getTeamscaleUserKey(username), StorageUtils.serialize((Serializable)loginData));
        if (!StringUtils.isEmpty((String)loginData.sub)) {
            this.store.putWithString(OpenIdSessionIndex.getOpenIdSubKey(loginData.sub), StorageUtils.serialize((Serializable)((Object)username)));
        }
        if (!StringUtils.isEmpty((String)loginData.sid)) {
            this.store.putWithString(OpenIdSessionIndex.getOpenIdSidKey(loginData.sid), StorageUtils.serialize((Serializable)((Object)username)));
        }
    }

    public void removeDataByUsername(String username) throws StorageException {
        Optional<LoginData> loginData = this.getLoginDataForUser(username);
        if (loginData.isPresent()) {
            ArrayList<String> keysToDelete = new ArrayList<String>();
            keysToDelete.add(OpenIdSessionIndex.getTeamscaleUserKey(username));
            if (!StringUtils.isEmpty((String)loginData.get().sub)) {
                keysToDelete.add(OpenIdSessionIndex.getOpenIdSubKey(loginData.get().sub));
            }
            if (!StringUtils.isEmpty((String)loginData.get().sid)) {
                keysToDelete.add(OpenIdSessionIndex.getOpenIdSidKey(loginData.get().sid));
            }
            this.store.removeWithStrings(keysToDelete);
        }
    }

    private static String getTeamscaleUserKey(String username) {
        return username + TEAMSCALE_USER_KEY_SUFFIX;
    }

    private static String getOpenIdSubKey(String sub) {
        return sub + OPENID_SUB_KEY_SUFFIX;
    }

    private static String getOpenIdSidKey(String sid) {
        return sid + OPENID_SID_KEY_SUFFIX;
    }

    @IndexValueClass
    public static class LoginData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final @Nullable String sub;
        private final @Nullable String sid;
        private final @Nullable String idToken;
        private final String authenticatorName;

        public LoginData(@Nullable String sub, @Nullable String sid, String idToken, String authenticatorName) {
            this.sub = sub;
            this.sid = sid;
            this.idToken = Objects.requireNonNull(idToken, "idToken");
            this.authenticatorName = authenticatorName;
        }

        public @Nullable String getSub() {
            return this.sub;
        }

        public @Nullable String getSid() {
            return this.sid;
        }

        public Optional<String> getIdToken() {
            return Optional.ofNullable(this.idToken);
        }

        public String getAuthenticatorName() {
            return this.authenticatorName;
        }
    }
}

