/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.saml;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.authenticate.saml.SamlAuthenticationOption;
import com.teamscale.core.authenticate.saml.SamlUtils;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.IOption;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.date.DateTimeUtils;

public class SamlCertificateRefreshTrigger
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration EXPIRATION_LIMIT = Duration.ofDays(60L);

    @Override
    public void execute() throws Exception {
        SamlCertificateRefreshTrigger.renewSamlCertificate(this.getOptionName(), this.indexLayer, false);
    }

    public static boolean renewSamlCertificate(String optionName, IndexLayer indexLayer, boolean force) throws StorageException {
        SamlAuthenticationOption triggeringOption = IOption.getServerOptionForName(SamlAuthenticationOption.class, optionName, indexLayer).orElseGet(() -> (SamlAuthenticationOption)CCSMAssert.fail((String)("Option for name " + optionName + " not found!")));
        if ((force || SamlCertificateRefreshTrigger.certificateShouldBeRenewed(triggeringOption)) && triggeringOption.generateCertificate()) {
            IOption.setServerOptionForName(optionName, triggeringOption, indexLayer);
            LOGGER.info("Updated the SAML certificate of " + optionName);
            return true;
        }
        return false;
    }

    private static boolean certificateShouldBeRenewed(SamlAuthenticationOption option) {
        Instant endTime = option.getCertificate().map(SamlUtils::parseCertificateFromBytes).map(X509Certificate::getNotAfter).map(Date::toInstant).orElseGet(DateTimeUtils::now);
        Duration remainingTime = Duration.between(DateTimeUtils.now(), endTime);
        return remainingTime.compareTo(EXPIRATION_LIMIT) <= 0;
    }
}

