/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.teamscale;

import com.teamscale.core.authenticate.teamscale.AuthenticatorBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.conqat.lib.commons.string.StringUtils;

public class HashedStoredPasswordAuthenticator
extends AuthenticatorBase {
    public static final String AUTHENTICATOR_NAME = "HashedStored";
    private static MessageDigest digest;
    private static final String SALT_SEPARATOR = "_";
    public static final int SALT_LENGTH = 32;
    private static Random saltGenerator;

    @Override
    public String getAuthenticatorIdentifier() {
        return AUTHENTICATOR_NAME;
    }

    @Override
    public boolean authenticate(User user, byte[] password, String authentication, ServerOptionIndex optionIndex) {
        String[] authenticationParts = authentication.split(SALT_SEPARATOR);
        if (authenticationParts.length == 2) {
            String hash = authenticationParts[0];
            String hashedPassword = HashedStoredPasswordAuthenticator.getHashedPasswort(password, authenticationParts[1]);
            return hash.equals(hashedPassword);
        }
        return authentication.equals(HashedStoredPasswordAuthenticator.hash(password, null));
    }

    private static String getHashedPasswort(byte[] password, String salt) {
        String hashedPassword = HashedStoredPasswordAuthenticator.hash(password, salt);
        Arrays.fill(password, (byte)0);
        return hashedPassword;
    }

    public static synchronized String hash(byte[] password, String salt) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)"Each Java should come with SHA-512 installed!");
            }
        }
        digest.reset();
        digest.update(password);
        if (!StringUtils.isEmpty((String)salt)) {
            digest.update(StringUtils.stringToBytes((String)salt));
        }
        return StringUtils.encodeAsHex((byte[])digest.digest());
    }

    @Override
    public boolean allowsPasswordChanges() {
        return true;
    }

    @Override
    public boolean allowsSwitching() {
        return true;
    }

    public static synchronized String generateSalt(int length) {
        if (saltGenerator == null) {
            saltGenerator = new SecureRandom();
        }
        byte[] saltBytes = new byte[length];
        saltGenerator.nextBytes(saltBytes);
        return StringUtils.encodeAsHex((byte[])saltBytes);
    }

    @Override
    public String generateNewAuthenticator(byte[] newPassword) {
        String salt = HashedStoredPasswordAuthenticator.generateSalt(32);
        String hash = HashedStoredPasswordAuthenticator.getHashedPasswort(newPassword, salt);
        return this.getAuthenticatorIdentifier() + ":" + hash + SALT_SEPARATOR + salt;
    }

    @Override
    public String sanitizeAuthenticator(String authenticationParameters) {
        return "anonymized";
    }
}

