/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.committree;

import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTreeNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.NullMarked;

@NullMarked
class CommitTreeCloneHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Function<String, String> branchNameAnonymizer;
    private final Map<CommitTreeRevision, CommitTreeNode> anonymizedNodesByAnonymizedRevision = new HashMap<CommitTreeRevision, CommitTreeNode>();
    private final Map<CommitTreeRevision, CommitTreeRevision> anonymizedRevisionsByOriginalRevision = new HashMap<CommitTreeRevision, CommitTreeRevision>();
    private final UnmodifiableMap<CommitTreeRevision, CommitTreeNode> nodesByRevision;
    private final UnmodifiableMap<String, CommitTreeNode> latestContainedNodeByBranch;
    private final UnmodifiableMap<CommitDescriptor, CommitTreeNode> nodesByAdjustedCommit;
    private final UnmodifiableSet<String> liveBranchNames;
    private final long lastExpandedTimestampInMs;

    private CommitTreeCloneHelper(Map<CommitTreeRevision, CommitTreeNode> nodesByRevision, Map<String, CommitTreeNode> latestContainedNodeByBranch, Map<CommitDescriptor, CommitTreeNode> nodesByAdjustedCommit, Set<String> liveBranchNames, long lastExpandedTimestampInMs, Function<String, String> branchNameAnonymizer) {
        this.nodesByRevision = CollectionUtils.asUnmodifiable(nodesByRevision);
        this.latestContainedNodeByBranch = CollectionUtils.asUnmodifiable(latestContainedNodeByBranch);
        this.nodesByAdjustedCommit = CollectionUtils.asUnmodifiable(nodesByAdjustedCommit);
        this.liveBranchNames = CollectionUtils.asUnmodifiable(liveBranchNames);
        this.lastExpandedTimestampInMs = lastExpandedTimestampInMs;
        this.branchNameAnonymizer = branchNameAnonymizer;
    }

    public static CommitTree deepCopy(Map<CommitTreeRevision, CommitTreeNode> nodesByRevision, Map<String, CommitTreeNode> latestContainedNodeByBranch, Map<CommitDescriptor, CommitTreeNode> nodesByAdjustedCommit, Set<String> liveBranchNames, long lastExpandedTimestampInMs, Function<String, String> branchNameAnonymizer) {
        return new CommitTreeCloneHelper(nodesByRevision, latestContainedNodeByBranch, nodesByAdjustedCommit, liveBranchNames, lastExpandedTimestampInMs, branchNameAnonymizer).deepCopyInternal();
    }

    private CommitTree deepCopyInternal() {
        this.createAnonymizedRawNodes();
        this.linkParentNodes();
        CommitTree anonymizedTree = new CommitTree(this.anonymizedNodesByAnonymizedRevision, this.anonymizeLatestContainedNodeByBranch(), this.anonymizeNodesByAdjustedCommit(), this.lastExpandedTimestampInMs, CommitTreeCloneHelper.createCommitTreeIndex(), this.anonymizeLiveBranchNames());
        this.adoptCommitTreeAndVisitAllNodes(anonymizedTree, (originalNode, anonymizedNode) -> {
            anonymizedNode.copyState((ICommitTreeNode)originalNode);
            this.copyInjectedParent((CommitTreeNode)originalNode, (CommitTreeNode)anonymizedNode);
            CommitTreeCloneHelper.copyAdjustedTimestamp(originalNode, anonymizedNode);
        });
        return anonymizedTree;
    }

    private void createAnonymizedRawNodes() {
        for (Map.Entry entry : this.nodesByRevision.entrySet()) {
            CommitTreeRevision revision = (CommitTreeRevision)entry.getKey();
            CommitTreeNode node = (CommitTreeNode)entry.getValue();
            CommitTreeRevision anonymizedRevision = new CommitTreeRevision(revision.getRevision(), this.branchNameAnonymizer.apply(revision.getBranchName()));
            this.anonymizedRevisionsByOriginalRevision.put(revision, anonymizedRevision);
            CommitTreeNode anonymizedNode = new CommitTreeNode(anonymizedRevision, node.getOriginalTimestamp(), node.getDiscoveryTimestamp());
            this.anonymizedNodesByAnonymizedRevision.put(anonymizedRevision, anonymizedNode);
        }
    }

    private void linkParentNodes() {
        for (Map.Entry entry : this.nodesByRevision.entrySet()) {
            CommitTreeRevision originalRevision = (CommitTreeRevision)entry.getKey();
            CommitTreeNode originalNode = (CommitTreeNode)entry.getValue();
            CommitTreeRevision anonymizedRevision = this.anonymizedRevisionsByOriginalRevision.get(originalRevision);
            CommitTreeNode anonymizedNode = this.anonymizedNodesByAnonymizedRevision.get(anonymizedRevision);
            originalNode.getParents().stream().map(this::getAnonymizedNode).flatMap(Optional::stream).forEach(anonymizedNode::addParent);
        }
    }

    private static CommitTreeIndex createCommitTreeIndex() {
        return new CommitTreeIndex((IStore)new InMemoryStore());
    }

    private void adoptCommitTreeAndVisitAllNodes(CommitTree anonymizedTree, BiConsumer<CommitTreeNode, CommitTreeNode> commitTreeNodeVisitor) {
        for (Map.Entry entry2 : CollectionUtils.sort((Collection)this.nodesByRevision.entrySet(), Comparator.comparingLong(entry -> ((CommitTreeNode)entry.getValue()).getAdjustedTimestamp().orElse(((CommitTreeNode)entry.getValue()).getOriginalTimestamp())))) {
            CommitTreeNode originalNode = (CommitTreeNode)entry2.getValue();
            Optional<CommitTreeNode> anonymizedNode = this.getAnonymizedNode(originalNode);
            if (anonymizedNode.isEmpty()) continue;
            anonymizedNode.get().adopt(anonymizedTree);
            commitTreeNodeVisitor.accept(originalNode, anonymizedNode.get());
        }
    }

    private static void copyAdjustedTimestamp(CommitTreeNode originalNode, CommitTreeNode anonymizedNode) {
        if (originalNode.getAdjustedTimestamp().isEmpty()) {
            return;
        }
        anonymizedNode.setAdjustedTimestamp(originalNode.getAdjustedTimestamp().getAsLong());
    }

    private void copyInjectedParent(CommitTreeNode originalNode, CommitTreeNode anonymizedNode) {
        if (originalNode.getInjectedParent() == null) {
            return;
        }
        CommitDescriptor originalInjectedParent = originalNode.getInjectedParent();
        String anonymizedInjectedBranchName = this.branchNameAnonymizer.apply(originalInjectedParent.getBranchName());
        CommitDescriptor anonymizedInjectedParent = new CommitDescriptor(anonymizedInjectedBranchName, originalInjectedParent.getTimestamp());
        anonymizedNode.setInjectedParent(anonymizedInjectedParent);
    }

    private Map<String, CommitTreeNode> anonymizeLatestContainedNodeByBranch() {
        HashMap<String, CommitTreeNode> anonymizedLatestContainedNodeByBranch = new HashMap<String, CommitTreeNode>();
        for (Map.Entry entry : this.latestContainedNodeByBranch.entrySet()) {
            String originalBranchName = (String)entry.getKey();
            CommitTreeNode originalNode = (CommitTreeNode)entry.getValue();
            String anonymizedBranchName = this.branchNameAnonymizer.apply(originalBranchName);
            Optional<CommitTreeNode> anonymizedNode = this.getAnonymizedNode(originalNode);
            if (anonymizedNode.isEmpty()) continue;
            anonymizedLatestContainedNodeByBranch.put(anonymizedBranchName, anonymizedNode.get());
        }
        return anonymizedLatestContainedNodeByBranch;
    }

    private Map<CommitDescriptor, CommitTreeNode> anonymizeNodesByAdjustedCommit() {
        HashMap<CommitDescriptor, CommitTreeNode> anonymizedNodesByAdjustedCommit = new HashMap<CommitDescriptor, CommitTreeNode>();
        for (Map.Entry entry : this.nodesByAdjustedCommit.entrySet()) {
            CommitDescriptor originalCommit = (CommitDescriptor)entry.getKey();
            CommitTreeNode originalNode = (CommitTreeNode)entry.getValue();
            String anonymizedBranchName = this.branchNameAnonymizer.apply(originalCommit.getBranchName());
            CommitDescriptor anonymizedCommit = new CommitDescriptor(anonymizedBranchName, originalCommit.getTimestamp());
            Optional<CommitTreeNode> anonymizedNode = this.getAnonymizedNode(originalNode);
            if (anonymizedNode.isEmpty()) continue;
            anonymizedNodesByAdjustedCommit.put(anonymizedCommit, anonymizedNode.get());
        }
        return anonymizedNodesByAdjustedCommit;
    }

    private Set<String> anonymizeLiveBranchNames() {
        return this.liveBranchNames.stream().map(this.branchNameAnonymizer).collect(Collectors.toSet());
    }

    private Optional<CommitTreeNode> getAnonymizedNode(CommitTreeNode originalNode) {
        CommitTreeRevision originalRevision = originalNode.getRevision();
        CommitTreeRevision anonymizedRevision = this.anonymizedRevisionsByOriginalRevision.get(originalRevision);
        CommitTreeNode anonymizedNode = this.anonymizedNodesByAnonymizedRevision.get(anonymizedRevision);
        if (anonymizedNode == null) {
            LOGGER.warn("Could not find anonymized node for revision {}", (Object)anonymizedRevision);
            return Optional.empty();
        }
        return Optional.of(anonymizedNode);
    }
}

