/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.concurrency;

import com.google.common.collect.Lists;
import com.teamscale.core.concurrency.ExecutorServiceParallelTaskExecutor;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;

public interface IParallelTaskExecutor {
    public static final int BATCH_SIZE = 10;

    default public OptionalInt maximumParallelism() {
        return OptionalInt.empty();
    }

    private static int determineBatchSize(IParallelTaskExecutor parallelTaskExecutor, List<?> tasks) {
        OptionalInt maximumParallelism = parallelTaskExecutor.maximumParallelism();
        if (maximumParallelism.isEmpty()) {
            return 10;
        }
        int parallelism = maximumParallelism.getAsInt();
        if (parallelism <= 1) {
            return tasks.size();
        }
        return Math.max(tasks.size() / parallelism / 4, 1);
    }

    default public <T> void processInParallelBatches(List<T> input, ConsumerWithException<List<T>, ?> batchProcessor) throws InterruptedException, ExecutionException {
        this.processInParallelBatches(input, batchProcessor, IParallelTaskExecutor.determineBatchSize(this, input));
    }

    default public <T> void processInParallelBatches(List<T> input, ConsumerWithException<List<T>, ?> batchProcessor, int batchSize) throws InterruptedException, ExecutionException {
        CCSMAssert.isNotNull(input, () -> String.format("Expected \"%s\" to be not null", "input"));
        CCSMAssert.isNotNull(batchProcessor, () -> String.format("Expected \"%s\" to be not null", "batchProcessor"));
        CCSMAssert.isTrue((batchSize > 0 ? 1 : 0) != 0, () -> String.format("Expected \"%s\" to be positive", "batchSize"));
        this.processInParallel(Lists.partition(input, (int)batchSize), batchProcessor);
    }

    default public <T> void processInParallel(Collection<T> input, ConsumerWithException<T, ?> elementProcessor) throws ExecutionException, InterruptedException {
        CCSMAssert.isNotNull(input, () -> String.format("Expected \"%s\" to be not null", "input"));
        CCSMAssert.isNotNull(elementProcessor, () -> String.format("Expected \"%s\" to be not null", "elementProcessor"));
        List callables = CollectionUtils.map(input, element -> () -> {
            elementProcessor.accept(element);
            return null;
        });
        this.executeInParallel(callables);
    }

    default public <T, A, R> R computeInParallelBatches(List<T> input, FunctionWithException<List<T>, A, ?> batchComputer, Collector<A, ?, R> collector) throws ExecutionException, InterruptedException {
        return this.computeInParallelBatches(input, batchComputer, collector, IParallelTaskExecutor.determineBatchSize(this, input));
    }

    default public <T, A, R> R computeInParallelBatches(List<T> input, FunctionWithException<List<T>, A, ?> batchComputer, Collector<A, ?, R> collector, int batchSize) throws ExecutionException, InterruptedException {
        CCSMAssert.isNotNull(input, () -> String.format("Expected \"%s\" to be not null", "input"));
        CCSMAssert.isNotNull(batchComputer, () -> String.format("Expected \"%s\" to be not null", "batchComputer"));
        CCSMAssert.isNotNull(collector, () -> String.format("Expected \"%s\" to be not null", "collector"));
        CCSMAssert.isTrue((batchSize > 0 ? 1 : 0) != 0, () -> String.format("Expected \"%s\" to be positive", "batchSize"));
        return this.computeInParallel(Lists.partition(input, (int)batchSize), batchComputer, collector);
    }

    default public <T, A, R> R computeInParallel(Collection<T> input, FunctionWithException<T, A, ?> elementComputer, Collector<A, ?, R> collector) throws ExecutionException, InterruptedException {
        CCSMAssert.isNotNull(input, () -> String.format("Expected \"%s\" to be not null", "input"));
        CCSMAssert.isNotNull(elementComputer, () -> String.format("Expected \"%s\" to be not null", "elementComputer"));
        CCSMAssert.isNotNull(collector, () -> String.format("Expected \"%s\" to be not null", "collector"));
        List callables = CollectionUtils.map(input, element -> () -> elementComputer.apply(element));
        return this.executeInParallelAndCombine(callables, collector);
    }

    default public <T> void executeInParallel(Collection<Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.executeInParallelAndCombine(tasks, IParallelTaskExecutor.noopCollector());
    }

    private static <T> Collector<T, Void, Void> noopCollector() {
        return Collector.of(() -> null, (ignored1, ignored2) -> {}, (ignored1, ignored2) -> null, new Collector.Characteristics[0]);
    }

    public <T, R> R executeInParallelAndCombine(Collection<Callable<T>> var1, Collector<T, ?, R> var2) throws ExecutionException, InterruptedException;

    public static IParallelTaskExecutor forExecutorService(ExecutorService executorService) {
        return new ExecutorServiceParallelTaskExecutor(executorService);
    }

    public static IParallelTaskExecutor sameThread() {
        return new IParallelTaskExecutor(){

            @Override
            public OptionalInt maximumParallelism() {
                return OptionalInt.of(1);
            }

            @Override
            public <T, R> R executeInParallelAndCombine(Collection<Callable<T>> tasks, Collector<T, ?, R> collector) throws ExecutionException, InterruptedException {
                return IParallelTaskExecutor.executeSequentially(tasks, collector);
            }
        };
    }

    private static <T, A, R> R executeSequentially(Collection<Callable<T>> tasks, Collector<T, A, R> collector) throws ExecutionException, InterruptedException {
        A resultContainer = collector.supplier().get();
        BiConsumer<A, A> accumulator = collector.accumulator();
        try {
            for (Callable<T> task : tasks) {
                accumulator.accept(resultContainer, task.call());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        return collector.finisher().apply(resultContainer);
    }
}

