/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.teamscale.core.cron.ECrontabMacro;
import com.teamscale.core.cron.InvalidCronPatternException;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.date.DateTimeUtils;

public final class CronExpression {
    private static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));
    private final String rawExpression;
    private final ExecutionTime parsedExpression;

    private CronExpression(String rawExpression, ExecutionTime parsedExpression) {
        CCSMAssert.isNotNull((Object)rawExpression, () -> String.format("Expected \"%s\" to be not null", "rawExpression"));
        CCSMAssert.isNotNull((Object)parsedExpression, () -> String.format("Expected \"%s\" to be not null", "parsedCronExpression"));
        this.rawExpression = rawExpression;
        this.parsedExpression = parsedExpression;
    }

    public static CronExpression of(String cronExpression) {
        try {
            return CronExpression.parse(cronExpression);
        }
        catch (InvalidCronPatternException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static CronExpression parse(String cronExpression) throws InvalidCronPatternException {
        if ((cronExpression = cronExpression.strip()).startsWith("@")) {
            ECrontabMacro crontabMacro = ECrontabMacro.valueOfSchedule(cronExpression);
            if (crontabMacro == null) {
                throw new InvalidCronPatternException(cronExpression, "Unknown cron macro");
            }
            cronExpression = crontabMacro.getExpression();
        }
        try {
            return new CronExpression(cronExpression, ExecutionTime.forCron((Cron)CRON_PARSER.parse(cronExpression)));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidCronPatternException(cronExpression, e);
        }
    }

    public Optional<ZonedDateTime> nextExecution(ZonedDateTime date) {
        return this.parsedExpression.nextExecution(date);
    }

    public Optional<ZonedDateTime> nextExecution() {
        return this.nextExecution(DateTimeUtils.zonedNow());
    }

    public boolean matches(ZonedDateTime date) {
        return this.parsedExpression.isMatch(date);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronExpression that = (CronExpression)o;
        return Objects.equals(this.rawExpression, that.rawExpression);
    }

    public int hashCode() {
        return Objects.hash(this.rawExpression);
    }

    public String toString() {
        return this.rawExpression;
    }
}

